<?php
/*
Plugin Name: Group email notifier for buddypress
Description: Envía correos a todos los miembros del grupo cuando se publica una nueva actividad en grupos de BuddyPress.
Version: 1.0.0
Author: José M. Sánchez
Author URI: https://alfeizar.net
License: GPLv3
License URI: https://www.gnu.org/licenses/gpl-3.0.html
*/

add_action('bp_activity_after_save', function ($activity) {
    if (
        $activity->component === 'groups' &&
        in_array($activity->type, ['activity_update', 'rtmedia_update']) &&
        $activity->id &&
        !empty($activity->content)
    ) {
        $contenido = $activity->content;
        $contenido_renderizado = '';


        // Mostrar comentario del usuario si hay
        // Detectar si el contenido tiene texto visible (sin enlaces, imágenes, etc.)
        // Extraer solo el texto puro antes de etiquetas conocidas (como imágenes, enlaces, vídeos)
        $sin_medios = preg_replace('/<img[^>]+>/i', '', $contenido); // eliminar imágenes
        $sin_medios = preg_replace('/<a[^>]*>.*?<\/a>/i', '', $sin_medios); // eliminar enlaces
        $sin_medios = preg_replace('/\\[.*?\\]/', '', $sin_medios); // eliminar shortcodes
        $texto_usuario = wp_strip_all_tags($sin_medios);

        if (!empty(trim($texto_usuario))) {
            $contenido_renderizado .= "<p><strong>💬 Comentario:</strong><br>$texto_usuario</p>";
        }


        // Imágenes de RTMedia
        if ($activity->type === 'rtmedia_update') {
            if (preg_match_all('/<img.*?src=[\'"]([^\'"]+)[\'"].*?>/i', $contenido, $img_matches)) {


                $contenido_renderizado .= "<p><strong>🖼 Imágenes:</strong></p>";
                $contenido_renderizado .= "<div style='display:grid; grid-template-columns: repeat(2, 1fr); gap:10px;'>";

                foreach ($img_matches[1] as $img_url) {
                    $img_url = esc_url($img_url);
                    $contenido_renderizado .= "<a href='$img_url' target='_blank'><img src='$img_url' style='width:40%; height:auto; border:1px solid #ccc;'></a>";
                }

                $contenido_renderizado .= "</div>";


                /*	
		foreach ($img_matches[1] as $img_url) {
            $img_url = esc_url($img_url);
            $contenido_renderizado .= "<p><strong>🖼 Imagen:</strong><br><a href='$img_url' target='_blank'><img width='50%' 					src='$img_url'></a></p>";
        }
		*/
            } else {
                $contenido_renderizado .= "<p>(No se pudieron detectar imágenes)</p>";
            }
        }







        // Si no se encontró contenido en los casos anteriores, limpiamos el texto
        if (empty($contenido_renderizado)) {
            $contenido_renderizado = "<p>" . wp_strip_all_tags($contenido) . "</p>";
        }

        // Obtener información del grupo
        $grupo = groups_get_group(['group_id' => $activity->item_id]);
        $nombre_grupo = $grupo ? esc_html($grupo->name) : 'Grupo desconocido';
        $url_grupo = $grupo ? bp_get_group_permalink($grupo) : '#';

        // Obtener el autor de la actividad
        $user_id = $activity->user_id;
        $autor_nombre = bp_core_get_user_displayname($user_id);
        $autor_link = bp_core_get_userlink($user_id);

        // Configuración del correo
        $asunto = "📥 $autor_nombre ha publicado en el grupo \"$nombre_grupo\"";
        $mensaje = '
            <html><head><meta charset="UTF-8"></head><body>
            <h2>Actividad nueva en el grupo <a href="' . $url_grupo . '">' . $nombre_grupo . '</a></h2>
            <p><strong>Autor:</strong> ' . $autor_link . '</p>
            <div style="background:#f9f9f9;padding:10px;border:1px solid #ccc;margin:10px 0;">' . $contenido_renderizado . '</div>
            <p><a href="' . $url_grupo . '">Ver grupo</a> | ID actividad: ' . $activity->id . '</p>
            </body></html>';

        $headers = ['Content-Type: text/html; charset=UTF-8'];

        // Obtener miembros del grupo
        $args = [
            'group_id' => $activity->item_id,
            'per_page' => false,
        ];
        $miembros = groups_get_group_members($args);

        $emails = [];
        if (!empty($miembros['members'])) {



            foreach ($miembros['members'] as $miembro) {
                $email = bp_core_get_user_email($miembro->ID);





                // Verificar las preferencias de notificación del usuario en este grupo
                $user_notify_pref = get_user_meta($miembro->ID, 'ass_group_notifications_' . $activity->item_id, true);

                // Si el usuario no tiene desactivadas las notificaciones (es decir, 'no')
                if ($email && $user_notify_pref !== 'no') {
                    $emails[] = $email;
                }
            }
        }


        // Agregar al admin si no está en la lista
        $admin_email = get_option('admin_email');
        if (!in_array($admin_email, $emails)) {
            $emails[] = $admin_email;
        }


        // Enviar los correos
        foreach ($emails as $email) {
            wp_mail($email, $asunto, $mensaje, $headers);
        }

        // Eliminar el uso de error_log()
        // Si deseas, podrías agregar otra forma de registro si es necesario, pero no en producción.
        // Ejemplo: wp_mail('tucorreo@dominio.com', 'Debug info', 'Actividad enviada a ' . count($emails) . ' usuarios');
    }
});



function genfbp_plugin_donation_section()
{
?>
    <div style="margin-top: 30px; padding: 20px; background: #f1f1f1; border-left: 4px solid #0073aa;">
        <h2>¿Te ha sido útil este plugin?</h2>
        <p>Si este plugin te ha ayudado y quieres apoyar su desarrollo, puedes hacer una pequeña donación 💖</p>
        <a href="https://www.paypal.com/donate/?hosted_button_id=JCHW87M9WKABE" target="_blank">

            <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . 'assets/images/btn_donate_LG.gif'); ?>" alt="Donar con PayPal" />

        </a>
    </div>
<?php
}

function genfbp_plugin_settings_page()
{
    echo '<div class="wrap">';
    echo '<h1>Group Email Notifier for BuddyPress</h1>';

    // Aquí iría el contenido de configuración del plugin (si agregas opciones más adelante)

    //genfbp_plugin_donation_section();

    echo '<div class="wrap">';
    echo '<h1>Group Email Notifier for BuddyPress</h1>';

    // Promo Pro
    genfbp_plugin_pro_promo_section();

    // Donación
    genfbp_plugin_donation_section();


    echo '</div>';
}

function genfbp_plugin_pro_promo_section()
{
?>
    <div style="margin-top: 30px; padding: 20px; background: #e0f7fa; border-left: 4px solid #0073aa;">
        <h2>¿Quieres más funciones?</h2>
        <p>La versión <strong>Pro 1.1</strong> permite enviar imágenes, vídeos y enlaces enriquecidos por correo.</p>
        <p><a href="https://alfeizar.net/courses/group-email-notifier-for-buddypress/" target="_blank" class="button button-primary">Descargar versión Pro</a></p>
    </div>
<?php
}


add_action('admin_menu', function () {
    add_options_page(
        'Group Email Notifier Settings',
        'Group Email Notifier',
        'manage_options',
        'genfbp-settings',
        'genfbp_plugin_settings_page'
    );
});
