<?php
if (!defined('ABSPATH')) exit;

/**
 * ============================================================================
 * MI MENSAJE – SETTINGS v1.0 (FREE)
 * ============================================================================
 */



/**
 * ---------------------------------------------------------------------------
 * Límites FREE (FIJOS)
 * ---------------------------------------------------------------------------
 */
$max_files    = 3;
$max_total_mb = 2;

$allowed_ext = array(
    'jpg',
    'jpeg',
    'png',
    'gif',
    'pdf'
);

/**
 * ---------------------------------------------------------------------------
 * Pasar configuración al JavaScript
 * ---------------------------------------------------------------------------
 */
wp_localize_script(
    'mi-mensaje-js',
    'MiMensajeConfig',
    array(
        'maxFiles'    => $max_files,
        'maxTotalMB' => $max_total_mb,
        'allowedExt' => $allowed_ext,
    )
);

/**
 * ============================================================================
 * MENÚ ADMIN
 * ============================================================================
 */
function mi_mensaje_admin_menu()
{
    add_menu_page(
        'Mensajes Privados',
        'Mensajes Privados',
        'manage_options',
        'mi-mensaje-ajustes',
        'mi_mensaje_render_settings_page',
        'dashicons-email-alt',
        30
    );



    add_submenu_page(
        'mi-mensaje-ajustes',
        'Información del Plugin',
        'Información del Plugin',
        'manage_options',
        'mi-mensaje-plugin-info',
        'mi_mensaje_plugin_info_page_free'
    );
}
add_action('admin_menu', 'mi_mensaje_admin_menu');










/**
 * Registrar ajustes (posición + color del botón)
 */
function mi_mensaje_registrar_ajustes()
{
    register_setting('mi_mensaje_opciones', 'mi_mensaje_posicion_boton');
    register_setting('mi_mensaje_opciones', 'mi_mensaje_color_boton');
    register_setting('mi_mensaje_opciones', 'mi_mensaje_redireccion_autor');
    register_setting('mi_mensaje_opciones', 'mi_mensaje_filtrar_activos');
}
add_action('admin_init', 'mi_mensaje_registrar_ajustes');

/**
 * Menú de configuración del botón flotante
 */
function mi_mensaje_configuracion_menu()
{
    add_options_page(
        'Configuración de Mi Mensaje',
        'Mi Mensaje',
        'manage_options',
        'mi-mensaje-configuracion',
        'mi_mensaje_configuracion_html'
    );
}
add_action('admin_menu', 'mi_mensaje_configuracion_menu');

/**
 * HTML del panel de configuración
 */
function mi_mensaje_configuracion_html()
{
    $pos_actual = get_option('mi_mensaje_posicion_boton', 'bottom-right');
    $color_actual = get_option('mi_mensaje_color_boton', '#0073aa');
?>
    <div class="wrap">
        <div class="mi-mensaje-card">

            <h1>⚙️ Configuración del Botón de Mensajes</h1>
            <form method="post" action="options.php">
                <?php settings_fields('mi_mensaje_opciones'); ?>
                <?php do_settings_sections('mi_mensaje_opciones'); ?>

                <table class="form-table">
                    <tr valign="top">
                        <th scope="row">Posición del botón flotante:</th>
                        <td>
                            <select name="mi_mensaje_posicion_boton">
                                <?php
                                $opciones = [
                                    'bottom-right' => 'Abajo a la derecha',
                                    'bottom-left'  => 'Abajo a la izquierda',
                                    'top-right'    => 'Arriba a la derecha',
                                    'top-left'     => 'Arriba a la izquierda',
                                ];
                                foreach ($opciones as $valor => $texto) {
                                    echo '<option value="' . esc_attr($valor) . '"' . selected($pos_actual, $valor, false) . '>' . esc_html($texto) . '</option>';
                                }



                                ?>
                            </select>
                        </td>
                    </tr>

                    <tr valign="top">
                        <th scope="row">Color del botón:</th>
                        <td>
                            <input type="color" name="mi_mensaje_color_boton" value="<?php echo esc_attr($color_actual); ?>">
                            <p class="description">Selecciona el color principal del botón flotante.</p>
                        </td>
                    </tr>




                    <tr valign="top">
                        <th scope="row">Redirigir /author/ → /perfil/</th>
                        <td>
                            <?php $redir = get_option('mi_mensaje_redireccion_autor', '0'); ?>
                            <label>
                                <input type="checkbox" name="mi_mensaje_redireccion_autor" value="1" <?php checked($redir, '1'); ?>>
                                Activar redirección automática a los perfiles personalizados
                            </label>
                            <p class="description">
                                Si se activa, cualquier URL de autor como <code>/author/juan</code> redirigirá a <code>/perfil/juan</code>.<br>
                                Si tienes activado un plugin para personalizar la página de autor, desactiva esta opción.
                            </p>
                        </td>
                    </tr>



                </table>

                <?php submit_button('Guardar cambios'); ?>
            </form>
        </div> <!-- cierre mi-mensaje-card -->
    </div> <!-- cierre wrap -->



<?php
}












/**
 * ============================================================================
 * INFO DEL PLUGIN – FREE
 * ============================================================================
 */
function mi_mensaje_plugin_info_page_free()
{
?>
    <div class="wrap">
        <h1>Información del Plugin</h1>

        <p><strong>Versión instalada:</strong> 1.0 (FREE)</p>

        <h2>Limitaciones de la versión gratuita</h2>
        <ul>
            <li><strong>Máx. archivos:</strong> 3</li>
            <li><strong>Tamaño máximo total:</strong> 2 MB</li>
            <li><strong>Tipos permitidos:</strong> jpg, jpeg, png, gif, pdf</li>
        </ul>

        <hr>

        <p style="margin-top:20px;">
            <a class="button button-primary"
                href="https://alfeizar.net/courses/sistema-de-mensajeria-interna-entre-usuarios-wordpress/"
                target="_blank">
                🚀 Descargar versión PRO (2.0)
            </a>
        </p>
    </div>
<?php
}


/**
 * ============================================================================
 * PÁGINA PRINCIPAL DE AJUSTES (FREE)
 * ============================================================================
 */
function mi_mensaje_render_settings_page()
{
?>
    <div class="wrap">
        <h1>Mensajes Privados – Ajustes</h1>

        <p>
            Estás usando la <strong>versión gratuita (1.0)</strong> del plugin.
        </p>

        <h2>Límites actuales</h2>
        <ul>
            <li><strong>Máx. archivos:</strong> 3</li>
            <li><strong>Tamaño máximo total:</strong> 2 MB</li>
            <li><strong>Tipos permitidos:</strong> jpg, jpeg, png, gif, pdf</li>
        </ul>

        <hr>

        <p>
            <a class="button button-primary"
                href="https://alfeizar.net/courses/sistema-de-mensajeria-interna-entre-usuarios-wordpress/"
                target="_blank">
                🚀 Pasar a versión PRO
            </a>
        </p>
    </div>
<?php
}
