document.addEventListener('DOMContentLoaded', function() {
    const inputFiles = document.querySelector('input[name="attachments[]"]');
    
    const maxFiles = miMensajeSettings.maxFiles;
    const maxTotalSizeBytes = miMensajeSettings.maxTotalSizeMB * 1024 * 1024;
    const allowedExtensions = miMensajeSettings.allowedExtensions;

    inputFiles.addEventListener('change', function() {
        let files = Array.from(inputFiles.files);
        if(files.length > maxFiles) {
            alert(`Solo puedes subir un máximo de ${maxFiles} archivos.`);
            inputFiles.value = '';
            return;
        }

        let totalSize = files.reduce((acc, file) => acc + file.size, 0);
        if(totalSize > maxTotalSizeBytes) {
            alert(`El tamaño total supera los ${miMensajeSettings.maxTotalSizeMB} MB.`);
            inputFiles.value = '';
            return;
        }

        for(let f of files) {
            let ext = f.name.split('.').pop().toLowerCase();
            if(!allowedExtensions.includes(ext)) {
                alert(`Archivo no permitido: ${f.name}`);
                inputFiles.value = '';
                return;
            }
        }
    });
});
