<?php
if (! defined('ABSPATH')) exit;



/**
 * Crea la tabla personalizada para los mensajes
 */
function mi_mensaje_crear_tabla_mensajes()
{
    global $wpdb;

    $table_name = $wpdb->prefix . 'author_messages';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE {$table_name} (
        id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
        conversation_id bigint(20) unsigned DEFAULT NULL,
        author_id bigint(20) unsigned NOT NULL,
        sender_id bigint(20) unsigned NOT NULL,
		propietario_id bigint(20) unsigned NOT NULL,
        es_remitente tinyint(1) DEFAULT 0 NOT NULL,
		subject varchar(255) NOT NULL,
        message longtext NOT NULL,
        attachments text,
        date_sent datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
		fecha_leido datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
        leido tinyint(1) DEFAULT 0,
        papelera tinyint(1) DEFAULT 0,
        PRIMARY KEY  (id),
        KEY conversation_id (conversation_id),
        KEY author_id (author_id),
        KEY sender_id (sender_id)
    ) {$charset_collate};";

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta($sql);

    error_log('✅ Intento de creación de tabla: ' . $table_name);
}


/**
 * ------------------------------------------------------------
 * 📄 Gestión de plantillas y creación de páginas del plugin
 * ------------------------------------------------------------
 */

/**
 * Devuelve la ruta absoluta del archivo de plantilla dentro del plugin
 */
if (! function_exists('mi_mensaje_template_path')) {
    function mi_mensaje_template_path($archivo)
    {
        return trailingslashit(plugin_dir_path(__FILE__)) . '../templates/' . $archivo;
    }
}

/**
 * Filtra qué plantilla se debe usar según el slug de la página
 */
if (! function_exists('mi_mensaje_cargar_plantillas')) {
    add_filter('template_include', 'mi_mensaje_cargar_plantillas', 99);
    function mi_mensaje_cargar_plantillas($template)
    {
        if (! is_singular('page')) {
            return $template;
        }

        $slug = get_post_field('post_name', get_post());

        $plantillas = array(
            //'author'                => 'author.php',
			'perfil'                => 'author.php',
            'mensaje'               => 'page-mensaje.php',
            'mensajes'              => 'page-mensajes.php',
            'mensajes-enviados'     => 'page-mensajes-enviados.php',
            'mensajes-de-usuario'   => 'page-mensajes-usuario.php',
            'papelera'              => 'page-papelera.php',
            'archivo-protegido'     => 'page-archivo-protegido.php',
            'redactar'              => 'page-redactar.php',
        );

        if (isset($plantillas[$slug])) {
            // Si existe una plantilla personalizada en el tema, usarla primero
            $tema_plantilla = get_stylesheet_directory() . '/' . $plantillas[$slug];
            if (file_exists($tema_plantilla)) {
                return $tema_plantilla;
            }

            // Si no, usar la plantilla incluida en el plugin
            $ruta = mi_mensaje_template_path($plantillas[$slug]);
            if (file_exists($ruta)) {
                return $ruta;
            }
        }

        return $template;
    }
}

/**
 * Crea automáticamente las páginas necesarias al activar el plugin
 */
if (! function_exists('mi_mensaje_crear_paginas_necesarias')) {
    function mi_mensaje_crear_paginas_necesarias()
    {
        $paginas = array(
            //'author'                => 'Perfil del autor',
            'perfil'                => 'Perfil del autor',
            'mensaje'               => 'Mensaje individual',
            'mensajes'              => 'Mis mensajes',
            'mensajes-enviados'     => 'Mensajes enviados',
            'mensajes-de-usuario'   => 'Mensajes de usuario',
            'papelera'              => 'Papelera',
            'archivo-protegido'     => 'Archivo protegido',
            'redactar'              => 'Redactar',
        );

        foreach ($paginas as $slug => $titulo) {
            if (! get_page_by_path($slug)) {
                wp_insert_post(array(
                    'post_title'   => $titulo,
                    'post_name'    => $slug,
                    'post_status'  => 'publish',
                    'post_type'    => 'page',
                    'post_content' => '[mi-mensaje-placeholder]',
                ));
            }
        }
    }

    // Ejecutar al activar el plugin
    register_activation_hook(__FILE__, 'mi_mensaje_crear_paginas_necesarias');
}

if ( ! function_exists( 'mimensajeplugin_get_author_link' ) ) {
    function mimensajeplugin_get_author_link( $user_id ) {
        $user = get_userdata( $user_id );
        if ( ! $user ) {
            return '#';
        }
        return home_url( '/perfil/' . $user->user_nicename . '/' );
    }
}

// ────────────────────────────────────────────────
// Autor personalizado (solo para el sistema de mensajes)
// ────────────────────────────────────────────────

add_action( 'init', 'mimensajeplugin_rewrite_rules' );
function mimensajeplugin_rewrite_rules() {
    add_rewrite_rule(
        '^perfil/([^/]+)/?',
        'index.php?autor=$matches[1]',
        'top'
    );
}


add_filter( 'query_vars', 'mimensajeplugin_query_vars' );
function mimensajeplugin_query_vars( $vars ) {
    $vars[] = 'autor';
    return $vars;
}



add_action( 'template_include', 'mimensajeplugin_load_author_template' );
function mimensajeplugin_load_author_template( $template ) {
    $username = get_query_var( 'autor' );
    if ( $username ) {
        $plugin_template = trailingslashit( plugin_dir_path( __FILE__ ) ) . '../templates/author.php';
        if ( file_exists( $plugin_template ) ) {
            return $plugin_template;
        }
    }
    return $template;
}








//=============================handle_send_author_message======================================================

$user_id   = get_current_user_id();
$author_id = isset($_POST['author_id']) ? intval($_POST['author_id']) : 0;
//$subject   = sanitize_text_field($_POST['subject']);
$subject = isset($_POST['subject']) ? sanitize_text_field($_POST['subject']) : '';

//$message   = sanitize_textarea_field( $_POST['message'] );
$message = isset($_POST['message']) ? wp_kses_post($_POST['message']) : '';

$date      = current_time('mysql');

global $wpdb;
$table = $wpdb->prefix . 'author_messages';


/**
 * Muestra miniaturas de archivos adjuntos (imágenes y otros)
 */

function mostrar_miniaturas($attachments)
{
    if (empty($attachments)) {
        return '';
    }

    $files = explode(',', $attachments);
    $upload_dir = wp_upload_dir();
    $base_url   = site_url('/archivo-protegido/?file='); // tu endpoint de descarga
    $base_dir   = trailingslashit($upload_dir['basedir']) . 'author_messages/';

    $output = '<div style="display:flex; flex-wrap:wrap; gap:10px; margin-top:8px;">';

    foreach ($files as $file_raw) {
        $file_name = trim($file_raw);
        $file_path = $base_dir . $file_name;
        $file_url  = $base_url . rawurlencode($file_name);

        if (! file_exists($file_path)) {
            continue;
        }

        $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));


        if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp', 'bmp'], true)) {
            // Ruta directa a la imagen en uploads
            $public_url = trailingslashit($upload_dir['baseurl']) . 'author_messages/' . rawurlencode($file_name);

            $output .= '<div class="archivo-icono" style="text-align:center;">
        <a href="' . esc_url($file_url) . '">
            <img src="' . esc_url($public_url) . '" style="width:80px; height:80px; object-fit:cover; border:1px solid #ccc; border-radius:4px;" title="' . esc_attr($file_name) . '">
        </a>
        <div class="archivo-nombre" style="font-size:0.8em; margin-top:4px;">' . esc_html($file_name) . '</div>
    </div>';
        } else {
            $icon = '📄';
            if ($ext === 'pdf') $icon = '📕';
            elseif (in_array($ext, ['doc', 'docx'])) $icon = '📝';
            elseif (in_array($ext, ['xls', 'xlsx'])) $icon = '📊';
            elseif (in_array($ext, ['zip', 'rar'])) $icon = '🗜️';
            elseif ($ext === 'mp3') $icon = '🎵';
            elseif ($ext === 'mp4') $icon = '🎞️';
            elseif ($ext === 'rvt') $icon = '🧱';
            elseif ($ext === 'dwg') $icon = '📐';

            $output .= '<div class="archivo-icono" style="text-align:center;">
                <a href="' . esc_url($file_url) . '" style="font-size:2em;">' . $icon . '</a>
                <div class="archivo-nombre" style="font-size:0.8em; margin-top:4px;">' . esc_html($file_name) . '</div>
            </div>';
        }
    }

    $output .= '</div>';

    return $output;
}




// Construimos el cuerpo en HTML



// suponiendo que $thread_rows puede venir de una consulta previa
$thread_rows = isset( $thread_rows ) ? $thread_rows : array();

$thread_html  = '<div style="font-family: Arial, sans-serif; color: #333;">';
$thread_html .= '<h3>Conversación completa (Asunto: ' . esc_html( $subject ) . ')</h3>';

if ( ! empty( $thread_rows ) ) {
    foreach ( $thread_rows as $row ) {
        // generar HTML por cada fila
        $thread_html .= '<p>' . esc_html( $row->message ) . '</p>';
    }
} else {
    $thread_html .= '<p>No hay mensajes en este hilo.</p>';
}

$thread_html .= '</div>';





$thread_html  = '<div style="font-family: Arial, sans-serif; color: #333;">';
$thread_html .= '<h3>Conversación completa (Asunto: ' . esc_html($subject) . ')</h3>';
if ($thread_rows) {

    foreach ($thread_rows as $row) {
        // Obtener display_name de remitente y destinatario
        $sender   = get_user_by('ID', intval($row->sender_id));
        $receiver = get_user_by('ID', intval($row->author_id));

        $sender_name   = $sender   ? $sender->display_name   : 'Usuario desconocido';
        $receiver_name = $receiver ? $receiver->display_name : 'Usuario desconocido';





        // Caja para cada mensaje del hilo



        $thread_html .= '<div style="margin:8px 0;"><strong>Archivos adjuntos:</strong><br>';
        $thread_html .= '<div style="display:flex; flex-wrap:wrap; gap:8px; margin-top:6px;">';

        // Adjuntos (miniaturas + iconos)
        if (! empty($row->attachments)) {
            $upload_dir  = wp_upload_dir();
            $dir_url     = trailingslashit($upload_dir['baseurl']) . 'author_messages/';
            $files_array = array_map('trim', explode(',', $row->attachments));

            //$thread_html .= '<p style="margin:8px 0;"><strong>Archivos adjuntos:</strong>';
            foreach ($files_array as $fname) {
                if ('' === $fname) {
                    continue;
                }




                // Normalizar nombre y extensión
                $clean_name = trim($fname);
                $ext        = strtolower(trim(pathinfo($clean_name, PATHINFO_EXTENSION)));
                $url_file   = esc_url($dir_url . rawurlencode($clean_name));



                if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp'], true)) {
                    // Miniatura de la imagen
                    $thread_html .= '<a href="' . $url_file . '" target="_blank" style="display:inline-block;">'
                        . '<img src="' . $url_file . '" '
                        . 'style="width:60px; height:auto; border:1px solid #ccc; border-radius:4px;" '
                        . 'alt="Miniatura">'
                        . '</a>';
                } else {
                    // Iconos para PDF, DOC, XLS, ZIP...
                    $icon = '📄';
                    if (in_array($ext, ['pdf'], true)) {
                        $icon = '📕';
                    } elseif (in_array($ext, ['doc', 'docx'], true)) {
                        $icon = '📝';
                    } elseif (in_array($ext, ['xls', 'xlsx'], true)) {
                        $icon = '📊';
                    } elseif (in_array($ext, ['zip', 'rar'], true)) {
                        $icon = '🗜️';
                    }



                    $thread_html .= '<a href="' . $url_file . '" target="_blank" '
                        . 'style="font-size:1.6em; display:inline-block; text-decoration:none;">'
                        . $icon
                        . '</a>';
                }
            }
            $thread_html .= '</div>'; // fin flex
        }

        $thread_html .= '</div>'; // fin bloque adjuntos
    }
} else {
    $thread_html .= '<p>No hay mensajes previos en este hilo.</p>';
}
$thread_html .= '</div>';


// fin contenedor



if (! function_exists('handle_send_author_message')) {

    function handle_send_author_message()
    {

        // Solo procesar POST con el nombre correcto del submit
        if (! isset($_POST['send_author_message'])) {
            return;
        }

        // Verificar nonce (coincidir con el que pones en el formulario)
        if (
            ! isset($_POST['send_author_message_nonce']) ||
            ! wp_verify_nonce($_POST['send_author_message_nonce'], 'send_author_message_action')
        ) {
            error_log('[mi-mensaje] Nonce inválido o ausente');
            return;
        }

        // Debe estar logueado
        if (! is_user_logged_in()) {
            error_log('[mi-mensaje] Usuario no logueado intentando enviar mensaje');
            return;
        }

        // Datos sanitizados
        $sender_id = get_current_user_id();
        $author_id = isset($_POST['author_id']) ? intval($_POST['author_id']) : 0;
        $subject   = isset($_POST['subject']) ? sanitize_text_field(wp_unslash($_POST['subject'])) : '';
        $message   = isset($_POST['message']) ? wp_kses_post(wp_unslash($_POST['message'])) : '';
        $parent_id = isset($_POST['parent_message_id']) ? intval($_POST['parent_message_id']) : 0;


        if ($author_id <= 0) {
            error_log('[mi-mensaje] author_id inválido: ' . print_r($_POST, true));
            return;
        }

        global $wpdb;
        $tabla = $wpdb->prefix . 'author_messages';

        // Manejar adjuntos
        $attachments_array = array();
        if (! empty($_FILES['attachments']['name'][0])) {
            require_once ABSPATH . 'wp-admin/includes/file.php';
            // forzamos subdirectorio author_messages mediante filtro temporal
            $subdir = 'author_messages';

            add_filter('upload_dir', function ($dirs) use ($subdir) {
                $dirs['subdir']  = '/' . trim($subdir, '/');
                $dirs['path']    = $dirs['basedir'] . $dirs['subdir'];
                $dirs['url']     = $dirs['baseurl'] . $dirs['subdir'];
                return $dirs;
            });

            foreach ($_FILES['attachments']['name'] as $i => $name) {
                if (empty($_FILES['attachments']['tmp_name'][$i])) {
                    continue;
                }
                $file = array(
                    'name'     => sanitize_file_name($_FILES['attachments']['name'][$i]),
                    'type'     => $_FILES['attachments']['type'][$i],
                    'tmp_name' => $_FILES['attachments']['tmp_name'][$i],
                    'error'    => $_FILES['attachments']['error'][$i],
                    'size'     => $_FILES['attachments']['size'][$i],
                );

                $upload_overrides = array('test_form' => false);
                $m = wp_handle_upload($file, $upload_overrides);

                if (isset($m['error'])) {
                    error_log('[mi-mensaje] Error al subir archivo: ' . $m['error']);
                    continue;
                }

                if (isset($m['file'])) {
                    // guardamos solo el nombre de archivo para compatibilidad con tu lógica
                    $attachments_array[] = basename($m['file']);
                }
            }

            // quitar filtro upload_dir (en caso de que otro código lo necesite)
            remove_all_filters('upload_dir');
        }

        $attachments_to_store = '';
        if (! empty($attachments_array)) {
            // Guardamos coma-separados: "a.jpg,b.pdf"
            $attachments_to_store = implode(',', $attachments_array);
        }

        // Preparar datos de inserción
        $data = array(
            'author_id'   => $author_id,
            'sender_id'   => $sender_id,
            'propietario_id'   => propietario_id,
            'subject'     => $subject,
            'message'     => $message,
            'attachments' => $attachments_to_store,
            'date_sent'   => current_time('mysql'),
            //'fecha_leido'   => current_time('mysql'),
			'leido'       => 0,
            'papelera'    => 0
			);

        // Si la tabla tiene columna parent_id, la añadimos (evita error si no existe)
        $has_parent = $wpdb->get_results($wpdb->prepare("SHOW COLUMNS FROM {$tabla} LIKE %s", 'parent_id'));
        if (! empty($has_parent) && $parent_id > 0) {
            $data['parent_id'] = $parent_id;
        }

        $format = array('%d', '%d', '%d','%s', '%s', '%s', '%s', '%s','%d', '%d');
        if (isset($data['parent_id'])) {
            $format[] = '%d';
        }

        $ok = $wpdb->insert($tabla, $data, $format);

        if (false === $ok) {
            error_log('[mi-mensaje] Error insertando mensaje: ' . $wpdb->last_error);
            // no hacemos wp_die para no romper la UX, solo log
        } else {
            $new_id = $wpdb->insert_id;

            // Redirigir: preferimos volver al parent_id (si viene), sino al nuevo mensaje
            $redirect_id = ($parent_id > 0) ? $parent_id : $new_id;

            // Evitar problemas si headers ya enviados: usar wp_safe_redirect
            wp_safe_redirect(add_query_arg(array('mensaje_id' => $redirect_id, 'reply' => 'ok'), home_url('/mensaje/')));
            exit;
        }
    }

    add_action('init', 'handle_send_author_message');
} // end if function_exists




// ──────────────────────────────────────────────
// Manejo del envío del formulario de mensajes
// ──────────────────────────────────────────────
function handle_send_author_message()
{

    if (
        isset($_POST['send_author_message']) &&
        isset($_POST['send_author_message_nonce']) &&
        wp_verify_nonce($_POST['send_author_message_nonce'], 'send_author_message_action')
    ) {

        global $wpdb;

        $author_id  = intval($_POST['author_id']);
        $subject    = sanitize_text_field($_POST['subject']);
        $message    = wp_kses_post($_POST['message']);
        $current_id = get_current_user_id();

// 🔹 Adjuntos		
// 🔹 Configuración de restricciones
$max_files      = 1;                  // máximo 1 archivo
$max_file_size  = 2 * 1024 * 1024;    // 2 MB
$allowed_ext    = array( 'jpg', 'jpeg', 'png', 'gif', 'pdf' );

$attachments = [];
$attachments_copia = [];
$errors_adjuntos = [];

if (!empty($_FILES['attachments']['name'][0])) {

    $files = $_FILES['attachments'];

    // 🔸 Validar número máximo de archivos
    if ( count($files['name']) > $max_files ) {
        $errors_adjuntos[] = "Solo puedes adjuntar un archivo.";
    }

    $upload_dir = wp_upload_dir();
    $base_dir   = trailingslashit($upload_dir['basedir']) . 'author_messages/';
    if (!file_exists($base_dir)) mkdir($base_dir, 0755, true);

    foreach ($files['name'] as $i => $name) {

        if (empty($files['tmp_name'][$i])) continue;

        $tmp_name = $files['tmp_name'][$i];
        $file_size = $files['size'][$i];
        $filename = sanitize_file_name($name);

        // 🔸 Validar tamaño individual
        if ($file_size > $max_file_size) {
            $errors_adjuntos[] = "El archivo '{$filename}' supera el tamaño máximo de 2 MB.";
            continue;
        }

        // 🔸 Validar extensión
        $file_ext = strtolower( pathinfo($filename, PATHINFO_EXTENSION) );
        if (!in_array($file_ext, $allowed_ext)) {
            $errors_adjuntos[] = "El archivo '{$filename}' no está permitido.";
            continue;
        }

        // 🔸 Evitar sobrescritura de nombres
        $final_name = $filename;
        $j = 1;
        while (file_exists($base_dir . $final_name)) {
            $ext_pos = strrpos($filename, '.');
            $name_only = $ext_pos !== false ? substr($filename, 0, $ext_pos) : $filename;
            $ext = $ext_pos !== false ? substr($filename, $ext_pos) : '';
            $final_name = $name_only . '(' . $j . ')' . $ext;
            $j++;
        }

        $dest = $base_dir . $final_name;

        // 🔸 Subir archivo
        if (move_uploaded_file($tmp_name, $dest)) {

            // Archivo original (destinatario)
            $attachments[] = $final_name;

            // Crear copia para el remitente
            $ext_pos = strrpos($final_name, '.');
            $name_only = $ext_pos !== false ? substr($final_name, 0, $ext_pos) : $final_name;
            $ext = $ext_pos !== false ? substr($final_name, $ext_pos) : '';
            $copy_name = $name_only . '-copia' . $ext;

            if (@copy($dest, $base_dir . $copy_name)) {
                $attachments_copia[] = $copy_name;
            }
        }
    }
}

// Si quieres mostrar errores:
if (!empty($errors_adjuntos)) {
    foreach ($errors_adjuntos as $err) {
        echo '<div class="error">'.$err.'</div>';
    }
}


// Guardamos cada lista por separado
$attachments_str = implode(',', $attachments);          // destinatario
$attachments_copia_str = implode(',', $attachments_copia); // remitente
		
        // ────────────────────────────────────────
        // Guardar mensaje en la base de datos
        // ────────────────────────────────────────
        $tabla = $wpdb->prefix . 'author_messages';
		
		
// 🔹 Conversation ID (igual para ambos)
	$conversation_id = isset($_POST['conversation_id']) ? intval($_POST['conversation_id']) : 0;


// 🔹 Insertar mensaje para el destinatario		
        $wpdb->insert(
            $tabla,
            array(
				'es_remitente'   => 0,				
                'author_id'   => $author_id,
                'sender_id'   => $current_id,
                'propietario_id'   => $author_id,
                'subject'     => $subject,
                'message'     => $message,
                'attachments' => $attachments_str,
                'date_sent'   => current_time('mysql'),
                //'fecha_leido'   => current_time('mysql'),				
                'leido'       => 0,
                'papelera'    => 0,
				'conversation_id'=> $conversation_id
            ),
            array('%d','%d', '%d', '%d','%s', '%s', '%s', '%s', '%d', '%d', '%d')
        );
		
		// 🔹 Insertar copia para el remitente
		$wpdb->insert(
            $tabla,
            array(
				'es_remitente'   => 1,
                'author_id'   => $author_id,
                'sender_id'   => $current_id,
                'propietario_id'   => $current_id,		
                'subject'     => $subject,
                'message'     => $message,
                'attachments' => $attachments_copia_str,
                'date_sent'   => current_time('mysql'),
                //'fecha_leido'   => current_time('mysql'),					
                'leido'       => 0,
                'papelera'    => 0,
				'conversation_id'=> $conversation_id
            ),
            array('%d','%d', '%d', '%d','%s', '%s', '%s', '%s', '%d', '%d', '%d')
        );
		

        // ────────────────────────────────────────
        // Enviar notificación por correo
        // ────────────────────────────────────────
        $recipient = get_userdata($author_id);

        if ($recipient && ! empty($recipient->user_email)) {
            $subject_mail = 'Nuevo mensaje de ' . wp_get_current_user()->display_name;

			/*
            $body  = '<p>Has recibido un nuevo mensaje:</p>';
            $body .= '<p><strong>Asunto:</strong> ' . esc_html($subject) . '</p>';
            $body .= '<p><strong>Mensaje:</strong><br>' . wpautop(wp_kses_post($message)) . '</p>';
			*/
			
			
			        $body = '
        <div style="font-family: Arial, sans-serif; font-size: 20px; color: #333; line-height: 1.6;">
            <p>Hola <strong>' . esc_html($destinatario_info->display_name) . '</strong>,
            has recibido un nuevo mensaje de <strong>' . wp_get_current_user()->display_name . '</strong>:</p>
			
		  <div style="background-color: #f9f9f9; padding: 20px; border-radius: 8px; margin: 15px 0; border: 1px solid #ddd;">Asunto:<br>
                ' . esc_html($subject)  . '
            </div>

            <div style="background-color: #f9f9f9; padding: 20px; border-radius: 8px; margin: 15px 0; border: 1px solid #ddd;">Mensaje:<br>
                ' . wpautop(wp_kses_post($message)) . '
            </div>

            <p style="font-size: 20px; color: #777;">
                Puedes responder directamente desde tu bandeja de mensajes:<br>
                <a href="'. esc_url(home_url('/mensajes/')) .  '" 
                   style="color:#2271b1; text-decoration:none;">Ver conversación completa</a>
            </p>

            <hr style="border:none; border-top:1px solid #ddd; margin:20px 0;">
            <p style="font-size: 20px; color: #999;">Este mensaje fue enviado desde 
                <a href="' . esc_url(home_url()) . '" 
                   style="color:#999; text-decoration:none;">' . get_bloginfo('name') . '</a>.
            </p>
        </div>';

        // Enviar correo HTML
			
			
			
			
			
			
			
			
			
			

            // Si hay adjuntos, añadirlos como miniaturas o enlaces
            if (! empty($attachments)) {
                $body .= '<p><strong>Archivos adjuntos:</strong></p><div style="margin-top:10px;">';

                foreach ($attachments as $file_name) {

                    // Construir URL real del archivo
                    $file_url = trailingslashit(wp_upload_dir()['baseurl']) . 'author_messages/' . $file_name;

                    // Enlace protegido
                    $enlace_protegido = esc_url(home_url('/archivo-protegido/?file=' . urlencode(basename($file_name))));

                    // Extensión del archivo
                    $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

                    // Contenedor
                    $body .= '<div style="display:inline-block;margin:6px;">';

                    if (in_array($ext, array('jpg', 'jpeg', 'png', 'gif', 'webp'))) {

                        // Mostrar imagen como miniatura clicable
                        $body .= '<a href="' . $enlace_protegido . '" target="_blank" style="display:inline-block;margin-right:8px;">';
                        $body .= '<img src="' . esc_url($file_url) . '" alt="' . esc_attr(basename($file_name)) . '" style="width:120px;height:auto;border-radius:6px;border:1px solid #ccc;">';
                        $body .= '</a>';
                    } else {
                        // Elegir icono según tipo
                        $icono = '📎'; // por defecto
                        if (in_array($ext, array('pdf'))) {
                            $icono = '📕';
                        } elseif (in_array($ext, array('doc', 'docx'))) {
                            $icono = '📘';
                        } elseif (in_array($ext, array('xls', 'xlsx'))) {
                            $icono = '📗';
                        } elseif (in_array($ext, array('zip', 'rar', '7z'))) {
                            $icono = '🗜️';
                        } elseif (in_array($ext, array('txt'))) {
                            $icono = '📄';
                        }

                        // Enlace con icono y nombre
                        $body .= '<p><a href="' . $enlace_protegido . '" target="_blank" style="text-decoration:none;color:#2271b1;font-weight:500;">'
                            . $icono . ' ' . esc_html(basename($file_name))
                            . '</a></p>';
                    }
                }
                $body .= '</div>';
            }

  
			
			
			
			
			//$body .= '<hr><p><a href="' . esc_url(home_url('/mensajes/')) . '">📩 Ver todos los mensajes</a></p>';

			
			
					$body .= '
  <p style="margin-top:30px;text-align:center;">
    <a href="https://alfeizar.net/mensajes/" 
       style="display:inline-block;padding:12px 20px;background:#0073aa;color:white;
       border-radius:6px;text-decoration:none;font-weight:bold;">
       📥 Ver mensaje en tu bandeja
    </a>
  </p>

  <div style="background:#f1f1f1;padding:15px;text-align:center;
       font-size:13px;color:#666;margin-top:25px;border-top:1px solid #ddd;">

    <p style="margin:0 0 6px 0;">
      Este correo fue enviado automáticamente por el sistema de mensajería interna de 
      <strong>Alfeizar.net</strong>.
    </p>

    <p style="margin:0 0 6px 0;color:#555;">
      <strong>No respondas desde Gmail u Outlook.</strong><br>
      Las respuestas por correo no llegan al usuario porque no están conectadas al sistema interno.
    </p>

    <p style="margin:0;color:#777;">
      Para contestar, utiliza siempre tu bandeja de mensajes en la web.
    </p>

  </div>
';
			
			
			
 
			
			
			wp_mail(
                $recipient->user_email,
                $subject_mail,
                $body,
                array('Content-Type: text/html; charset=UTF-8')
            );
        }

        // ────────────────────────────────────────
        // Redirigir tras enviar
        // ────────────────────────────────────────


        wp_redirect(
            add_query_arg(
                'mensaje_enviado',
                '1',
                home_url('/mensajes-enviados/')
            )
        );
        exit;
    }
}

add_action('init', 'handle_send_author_message');







/**
 * Muestra un aviso en el escritorio de WordPress tras activar el plugin
 */
add_action('admin_notices', 'mi_mensaje_mostrar_aviso_copia_author');
function mi_mensaje_mostrar_aviso_copia_author()
{
    if ($mensaje = get_transient('mi_mensaje_author_status')) {
        delete_transient('mi_mensaje_author_status');
        $clase = 'notice notice-info';

        switch ($mensaje) {
            case 'copiado':
                $texto = '✅ La plantilla <code>author.php</code> se copió correctamente al tema activo.';
                break;
            case 'existe':
                $texto = 'ℹ️ La plantilla <code>author.php</code> ya existía en el tema y no se sobreescribió.';
                break;
            case 'origen_no_existe':
                $texto = '⚠️ No se pudo encontrar la plantilla original <code>author.php</code> en el plugin.';
                $clase = 'notice notice-warning';
                break;
            case 'fallo':
            default:
                $texto = '❌ Hubo un error al copiar la plantilla <code>author.php</code> al tema activo.';
                $clase = 'notice notice-error';
                break;
        }

        echo '<div class="' . esc_attr($clase) . '"><p>' . $texto . '</p></div>';
    }
}





// ICONO DE MENSAJES UNIVERSAL

add_action('wp_footer', 'mi_insertar_boton_correo_flotante');
function mi_insertar_boton_correo_flotante()
{
    if (is_user_logged_in()) {
        $user_id = get_current_user_id();
        global $wpdb;

        $table_name = $wpdb->prefix . 'author_messages';
        $url    = esc_url(home_url('/mensajes/'));
        $pos    = get_option('mi_mensaje_posicion_boton', 'bottom-right');
        $color  = get_option('mi_mensaje_color_boton', '#0073aa'); // 👈 color configurable

		// Obtener número de mensajes no leídos (solo recibidos de otros)

	
	
		$current_user_id = get_current_user_id();
		$no_leidos = (int) $wpdb->get_var(
    	$wpdb->prepare( 
		"SELECT COUNT(*)
         FROM $table_name
         WHERE author_id = %d
     	 AND propietario_id = %d
		 AND es_remitente = 0
    	 AND leido = 0 
         AND papelera = 0",
        $current_user_id,   // para sender_id
        $current_user_id    // para propietario_id (el del remitente)
   		 )
		);
		

        // Posiciones CSS
        $posiciones = [
            'bottom-right' => 'bottom: 20px; right: 20px;',
            'bottom-left'  => 'bottom: 20px; left: 20px;',
            'top-right'    => 'top: 20px; right: 20px;',
            'top-left'     => 'top: 20px; left: 20px;',
        ];
        $style = isset($posiciones[$pos]) ? $posiciones[$pos] : $posiciones['bottom-right'];

        echo '
        <a id="correo-flotante-wp" href="' . $url . '" title="Mi Correo">📨
            ' . ($no_leidos > 0 ? '<span class="mi-badge">' . $no_leidos . '</span>' : '') . '
        </a>
        <style>
        #correo-flotante-wp {
            position: fixed;
            ' . $style . '
            background: ' . esc_attr($color) . ';
            color: white;
            border-radius: 50%;
            padding: 16px;
            font-size: 1.8em;
            z-index: 9999;
            text-align: center;
            box-shadow: 0 4px 10px rgba(0,0,0,0.3);
            text-decoration: none;
            transition: background 0.3s ease;
        }
        #correo-flotante-wp:hover {
            background: #005177;
        }
        #correo-flotante-wp .mi-badge {
            position: absolute;
            top: -6px;
            right: -6px;
            background: red;
            color: white;
            border-radius: 50%;
            font-size: 0.7em;
            padding: 4px 6px;
            line-height: 1;
            font-weight: bold;
        }
        </style>';
    }
}





/**
 * Procesar el envío del formulario de redacción
 */
add_action('init', 'mi_mensaje_procesar_envio');
function mi_mensaje_procesar_envio()
{
    if (isset($_POST['mi_mensaje_enviar'])) {
        global $wpdb;
        $table_name = $wpdb->prefix . 'author_messages';

        $nombre_destino = sanitize_text_field($_POST['buscar_usuario']);
        $asunto = sanitize_text_field($_POST['asunto']);
        $mensaje = wp_kses_post($_POST['mensaje']);
        $remitente = get_current_user_id();

        // Buscar usuario destino por login o display_name
        $usuario = get_user_by('login', $nombre_destino);
        if (!$usuario) {
            $usuario = get_user_by('display_name', $nombre_destino);
        }

        if ($usuario) {
            // Guardar adjuntos (opcional)
            $attachments_urls = [];
            if (!empty($_FILES['attachments']['name'][0])) {
                require_once ABSPATH . 'wp-admin/includes/file.php';
                foreach ($_FILES['attachments']['name'] as $key => $filename) {
                    if ($_FILES['attachments']['error'][$key] === 0) {
                        $file = [
                            'name'     => $filename,
                            'type'     => $_FILES['attachments']['type'][$key],
                            'tmp_name' => $_FILES['attachments']['tmp_name'][$key],
                            'error'    => $_FILES['attachments']['error'][$key],
                            'size'     => $_FILES['attachments']['size'][$key],
                        ];
                        $upload = wp_handle_upload($file, ['test_form' => false]);
                        if (!isset($upload['error'])) {
                            $attachments_urls[] = $upload['url'];
                        }
                    }
                }
            }

            // Insertar mensaje
            $wpdb->insert($table_name, [
                'author_id' => $usuario->ID,
                'sender_id' => $remitente,
                'subject'   => $asunto,
                'message'   => $mensaje,
                'attachments' => maybe_serialize($attachments_urls),
            ]);

            wp_redirect(add_query_arg('enviado', '1', wp_get_referer()));
            exit;
        }
    }
}

/**
 * Búsqueda AJAX de usuarios
 */
add_action('wp_ajax_buscar_usuarios', 'mi_mensaje_buscar_usuarios');
function mi_mensaje_buscar_usuarios()
{
    global $wpdb;
    $term = '%' . $wpdb->esc_like($_GET['term']) . '%';
    $usuarios = $wpdb->get_results(
        $wpdb->prepare("
            SELECT ID, user_login, display_name 
            FROM {$wpdb->users}
            WHERE user_login LIKE %s OR display_name LIKE %s
            LIMIT 10
        ", $term, $term)
    );

    wp_send_json($usuarios);
}



/**
 * AJAX: Buscar usuarios (compatible con BuddyPress)
 */
add_action('wp_ajax_buscar_usuarios_bp', 'mi_mensaje_buscar_usuarios_bp');
function mi_mensaje_buscar_usuarios_bp()
{
    global $wpdb;

    $term = '%' . $wpdb->esc_like($_GET['term']) . '%';
    $usuarios = $wpdb->get_results(
        $wpdb->prepare("
            SELECT ID, user_login, display_name 
            FROM {$wpdb->users}
            WHERE user_login LIKE %s OR display_name LIKE %s
            LIMIT 10
        ", $term, $term)
    );

    $resultado = [];

    foreach ($usuarios as $u) {
        // Detectar si BuddyPress está activo
        if (function_exists('bp_core_fetch_avatar')) {
            $avatar = bp_core_fetch_avatar([
                'item_id' => $u->ID,
                'type'    => 'thumb',
                'html'    => false
            ]);
        } else {
            $avatar = get_avatar_url($u->ID, ['size' => 50]);
        }

        $resultado[] = [
            'ID'           => $u->ID,
            'user_login'   => $u->user_login,
            'display_name' => $u->display_name,
            'avatar'       => $avatar
        ];
    }

    wp_send_json($resultado);
}


/**
 * Redirigir /author/usuario → /perfil/usuario
 */
/*
function mi_redirigir_autor_a_perfil() {
    if ( is_author() ) {

        $author_slug = get_query_var( 'author_name' );
        if ( ! $author_slug ) {
            return;
        }

        $nuevo_url = home_url( '/perfil/' . $author_slug . '/' );

        // Redirección 301 permanente
        wp_redirect( $nuevo_url, 301 );
        exit;
    }
}
add_action( 'template_redirect', 'mi_redirigir_autor_a_perfil' );

*/

/**
 * Redirigir /author/usuario → /perfil/usuario si la opción está activa
 */
function mi_redirigir_autor_a_perfil() {

    // ✔ SOLO SI EL ADMIN LO HA ACTIVADO
    if (! get_option('mi_mensaje_redireccion_autor')) {
        return;
    }

    if (is_author()) {

        $author_slug = get_query_var('author_name');
        if (!$author_slug) {
            return;
        }

        $nuevo_url = home_url('/perfil/' . $author_slug . '/');

        wp_redirect($nuevo_url, 301);
        exit;
    }
}
add_action('template_redirect', 'mi_redirigir_autor_a_perfil');

add_action('admin_head', function () {
    $pantalla = get_current_screen();

    if ($pantalla && $pantalla->id === 'settings_page_mi-mensaje-configuracion') {
        ?>
        <style>
        /* ------------------------------------------------------  
           PANEL GENERAL (Tipo WooCommerce settings)
        ---------------------------------------------------------*/
        .wrap h1 {
            margin-bottom: 20px !important;
            padding-bottom: 10px;
            border-bottom: 1px solid #ddd;
        }

        /* Contenedor estilo card */
        .mi-mensaje-card {
            background: #fff;
            border-radius: 12px;
            padding: 25px 30px;
            margin-top: 25px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }

        /* Form-table modernizada */
        .mi-mensaje-card .form-table th {
            width: 250px;
            font-weight: 600;
            padding-top: 18px;
        }

        .mi-mensaje-card .form-table td {
            padding-top: 15px;
            padding-bottom: 15px;
        }

        /* Hover muy sutil */
        .mi-mensaje-card .form-table tr:hover td,
        .mi-mensaje-card .form-table tr:hover th {
            background: #f8f9fa;
        }

        /* Checkbox más visible */
        .mi-mensaje-card input[type="checkbox"] {
            transform: scale(1.25);
            cursor: pointer;
            margin-right: 8px;
        }

        /* Select modernizado */
        .mi-mensaje-card select {
            padding: 6px 10px;
            border-radius: 6px;
        }

        /* Color picker más integrado */
        .mi-mensaje-card input[type="color"] {
            width: 60px;
            height: 35px;
            padding: 2px;
            border-radius: 6px;
        }

        /* Botón guardar con más presencia */
        .mi-mensaje-card .button-primary {
            margin-top: 20px;
            padding: 10px 22px;
            height: auto;
            font-size: 15px;
            border-radius: 6px;
        }

        </style>
        <?php
    }
});

// VERSIONES

function mi_mensaje_is_pro() {
    return defined('MI_MENSAJE_PLUGIN_PRO') && MI_MENSAJE_PLUGIN_PRO === true;
}



function mi_mensaje_get_upload_limits() {

    $es_free = ! mi_mensaje_is_pro();

    return array(
        'max_files' => $es_free ? 3 : 20,
        'max_total_mb' => $es_free ? 2 : 200,
        'allowed_ext' => $es_free
            ? array('jpg','jpeg','png','gif','pdf')
            : array(
                'jpg','jpeg','png','gif',
                'mp3','mp4',
                'pdf','doc','docx','xls','xlsx','txt',
                'zip','rar',
                'rvt','dwg',
                'skp','skb'
            ),
    );
}














