<?php

/**
 * Plugin Name: Mi Mensaje Plugin
 * Description: Sistema personalizado de mensajería interna entre usuarios.
 * Version: 1.0.0
 * Author: José M. Sánchez
 * Author URI: https://alfeizar.net
 * License: GPLv3
 * License URI: https://www.gnu.org/licenses/gpl-3.0.html
 */

if (! defined('ABSPATH')) {
    exit;
}

// 🧱 Constantes globales
define('MI_MENSAJE_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('MI_MENSAJE_PLUGIN_URL', plugin_dir_url(__FILE__));


// 🔧 Incluir funciones principales
require_once MI_MENSAJE_PLUGIN_DIR . 'includes/functions-core.php';




// 🎨 Encolar estilos en el frontend
add_action('wp_enqueue_scripts', 'mi_mensaje_encolar_estilos');
function mi_mensaje_encolar_estilos()
{
    wp_enqueue_style(
        'mi-mensaje-style',
        MI_MENSAJE_PLUGIN_URL . 'assets/css/plugin-style.css',
        array(),
        '1.0'
    );
}


// ⚙️ Incluir ajustes del administrador solo en el backend
if (is_admin()) {
    require_once MI_MENSAJE_PLUGIN_DIR . 'admin/settings-page-free.php';
}



/**
 * 🚀 Función de activación del plugin
 */
function mi_mensaje_plugin_activar()
{
    global $wpdb;

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';

    if (function_exists('mi_mensaje_crear_tabla_mensajes')) {
        mi_mensaje_crear_tabla_mensajes();
        error_log('✅ Intento de creación de tabla: ' . $wpdb->prefix . 'author_messages');
    } else {
        error_log('❌ No se encontró mi_mensaje_crear_tabla_mensajes');
    }

    if (function_exists('mi_mensaje_crear_paginas_necesarias')) {
        mi_mensaje_crear_paginas_necesarias();
    } else {
        error_log('❌ No se encontró mi_mensaje_crear_paginas_necesarias');
    }
    /*
    if (function_exists('mi_mensaje_copiar_plantillas')) {
        mi_mensaje_copiar_plantillas();
    } else {
        error_log('❌ No se encontró mi_mensaje_copiar_plantillas');
    }
    */
    error_log('✅ Activación completada correctamente.');
}

// Registrar hook de activación
register_activation_hook(__FILE__, 'mi_mensaje_plugin_activar');
