<?php
/**
 * Template Name: Archivo protegido
 */

if ( ! is_user_logged_in() ) {
    wp_redirect( home_url( '/wp-login.php' ) );
    exit;
}

get_header();

//$file = isset($_GET['file']) ? basename( sanitize_file_name($_GET['file']) ) : '';
$file = isset($_GET['file']) ? basename( urldecode( $_GET['file'] ) ) : '';


$upload_dir = wp_upload_dir();
$file_path = trailingslashit($upload_dir['basedir']) . 'author_messages/' . $file;
$file_url  = trailingslashit($upload_dir['baseurl']) . 'author_messages/' . rawurlencode($file);
$ext       = strtolower( pathinfo( $file, PATHINFO_EXTENSION ) );

echo '<div class="container" style="padding: 2em 1em;">';
echo '<a href="javascript:history.back()" class="button" style="margin-bottom: 20px;">⬅️ Volver</a>';

echo '<a href="https://alfeizar.net/mensajes" class="button" style="margin-bottom: 20px;">📥 Mis Mensajes</a>';

if ( ! file_exists( $file_path ) ) {
    echo '<p style="color:red;">Archivo no encontrado.</p>';
    echo '</div>';
    get_footer();
    exit;
}

echo '<h2>Archivo protegido: ' . esc_html( $file ) . '</h2><br>';

// 📷 Imagenes
if ( in_array( $ext, [ 'jpg', 'jpeg', 'png', 'gif', 'webp' ] ) ) {
    echo '<img src="' . esc_url( $file_url ) . '" style="max-width:100%; border:1px solid #ccc; border-radius:6px;" oncontextmenu="return false;">';

// 🎧 Audio
} elseif ( $ext === 'mp3' ) {
    echo '<audio controls style="width:100%;" oncontextmenu="return false;">
            <source src="' . esc_url( $file_url ) . '" type="audio/mpeg">
            Tu navegador no soporta audio.
          </audio>';
/*
// 🎞️ Video
} elseif ( $ext === 'mp4' ) {
    echo '<video controls style="width:100%; max-width:800px; border-radius:8px;" oncontextmenu="return false;">
            <source src="' . esc_url( $file_url ) . '" type="video/mp4">
            Tu navegador no soporta video.
          </video>';
*/

} elseif ( $ext === 'mp4' ) {
    echo '<div style="max-width:800px;margin:0 auto;">';
    echo '<video controls style="width:100%; border-radius:8px;" oncontextmenu="return false;">
            <source src="' . esc_url( $file_url ) . '" type="video/mp4">
            Tu navegador no soporta vídeo.
          </video>';
    echo '<p style="margin-top:10px; font-size:0.9em; color:#666;">
            ⚠️ Para asegurar la compatibilidad, se recomienda que los vídeos estén codificados en <strong>H.264 (video)</strong> y <strong>AAC (audio)</strong>.
          </p>';
    echo '</div>';


// 📄 PDF
} elseif ( $ext === 'pdf' ) {
    echo do_shortcode('[pdf-embedder url="' . esc_url( $file_url ) . '"]');

// 📁 Archivos no visualizables (Word, Excel, DWG, RVT, ZIP, etc.)
} else {
    echo '<p style="margin-top: 1em;">Este tipo de archivo no puede visualizarse directamente en el navegador. Pulsa el botón para abrirlo o descargarlo con tu software habitual.</p>';
    echo '<a href="' . esc_url( $file_url ) . '" class="button" style="margin-top: 1em;">📄 Abrir archivo</a>';
}

echo '</div>';
get_footer();

