<?php
/**
 * Template Name: Mensaje Individual
 * Template Post Type: page
 */
if (!defined('ABSPATH')) exit;

if (!is_user_logged_in()) {
    wp_redirect(wp_login_url());
    exit;
}

require_once MI_MENSAJE_PLUGIN_DIR . 'includes/functions-core.php';

global $wpdb;
$table_name = $wpdb->prefix . 'author_messages';

// Obtener datos del mensaje actual
global $wpdb;
$current_user = wp_get_current_user();
$message_id   = isset($_GET['mensaje_id']) ? intval($_GET['mensaje_id']) : 0;

get_header();

// Obtener mensaje
$message = $wpdb->get_row(
    $wpdb->prepare(
        "SELECT * FROM {$table_name} WHERE id = %d AND ( sender_id = %d OR author_id = %d )",
        $message_id,
        $current_user->ID,
        $current_user->ID
    )
);

if ( ! $message ) {
    echo '<p>No tienes permiso para ver este mensaje o no existe.</p>';
    get_footer();
    exit;
}

// Marcar como leído (si corresponde)
if ( intval( $current_user->ID ) === intval( $message->author_id ) && intval( $message->leido ) === 0 ) {

    $wpdb->update(
        $table_name,
        [
            'leido' => 1,
            'fecha_leido' => current_time( 'mysql' )
        ],
        [ 'id' => $message_id ],
        [ '%d', '%s' ],
        [ '%d' ]
    );

    // Si quieres marcar el anterior también (tal como lo tenías)
    if ( $message_id - 1 > 0 ) {
        $wpdb->update(
            $table_name,
            [
                'leido' => 1,
                'fecha_leido' => current_time( 'mysql' )
            ],
            [ 'id' => $message_id - 1 ],
            [ '%d', '%s' ],
            [ '%d' ]
        );
    }
}

$reply_subject_prefill = 'RE: ' . $message->subject;
$upload_dir = wp_upload_dir();
$base_url   = trailingslashit( $upload_dir['baseurl'] ) . 'author_messages/';

// Obtener hilo por conversation_id
$thread = $wpdb->get_results(
    $wpdb->prepare(
        "SELECT * FROM {$table_name}
         WHERE conversation_id = %d
           AND propietario_id = %d
         ORDER BY date_sent ASC",
        $message->conversation_id,
        $current_user->ID
    )
);

?>

<link rel="stylesheet" type="text/css"
href="<?php echo esc_url( plugins_url( 'assets/css/plugin-style.css', dirname(__FILE__) ) ); ?>">

<div id="buddypress">
    <div class="container">
        <div class="bp-feedback">

            <h3 class="mensajes-titulo">
                <span class="titulo">✏️ Conversación</span>
                <span class="menu-links">
                    <a href="<?php echo esc_url( home_url( '/mensajes/' ) ); ?>" class="recibidos">
                        <svg viewBox="0 0 24 24"><path d="M14 5l7 7-7 7M21 12H3"/></svg>
                        Recibidos
                    </a>

                    <a href="<?php echo esc_url( home_url( '/mensajes-enviados/' ) ); ?>" class="enviados">
                        <svg viewBox="0 0 24 24"><path d="M14 5l7 7-7 7M21 12H3"/></svg>
                        Enviados
                    </a>

                    <a href="<?php echo esc_url( home_url( '/papelera/' ) ); ?>" class="papelera">
                        <svg viewBox="0 0 24 24"><path d="M3 6h18M8 6v14h8V6m-5-3h2a1 1 0 0 1 1 1v2H7V4a1 1 0 0 1 1-1z"/></svg>
                        Papelera
                    </a>
                </span>
            </h3>

            <h3><br> ✉️ <b><?php echo esc_html( $message->subject ); ?></b></h3>

<?php
// Funciones auxiliares (si ya las tienes en otro fichero, puedes omitirlas aquí)
function obtener_avatar_usuario( $user_id, $size = 50, $html = true ) {
    if ( function_exists( 'bp_core_fetch_avatar' ) ) {
        return bp_core_fetch_avatar( [
            'item_id' => $user_id,
            'type'    => 'thumb',
            'width'   => $size,
            'height'  => $size,
            'html'    => $html,
        ] );
    }

    if ( function_exists( 'learn_press_get_profile_picture' ) ) {
        $avatar_url = learn_press_get_profile_picture( $user_id );
        if ( ! empty( $avatar_url ) ) {
            return $html
                ? '<img src="' . esc_url( $avatar_url ) . '" width="' . intval( $size ) . '" height="' . intval( $size ) . '" class="avatar avatar-' . intval( $size ) . ' lp-avatar" alt="avatar" />'
                : esc_url( $avatar_url );
        }
    }

    if ( $html ) {
        return get_avatar( $user_id, $size );
    } else {
        return get_avatar_url( $user_id, [ 'size' => $size ] );
    }
}

function obtener_nombre_usuario( $user_id ) {
    if ( function_exists( 'bp_core_get_user_displayname' ) ) {
        return bp_core_get_user_displayname( $user_id );
    } else {
        $user = get_userdata( $user_id );
        return $user ? $user->display_name : 'Usuario';
    }
}

function obtener_perfil_usuario( $user_id ) {
    if ( function_exists( 'bp_core_get_user_domain' ) ) {
        return bp_core_get_user_domain( $user_id );
    } else {
        return get_author_posts_url( $user_id );
    }
}
?>

<div class="message-meta" style="display:flex; gap:20px; margin-bottom:15px;">
    <div class="sender" style="display:flex; align-items:center; gap:10px;">
        <?php echo wp_kses_post( obtener_avatar_usuario( $message->sender_id, 50, true ) ); ?>
        <div>
            <strong>De:</strong><br>
            <a href="<?php echo esc_url( obtener_perfil_usuario( $message->sender_id ) ); ?>">
                <?php echo esc_html( obtener_nombre_usuario( $message->sender_id ) ); ?>
            </a>
        </div>
    </div>

    <div class="recipient" style="display:flex; align-items:center; gap:10px;">
        <?php echo wp_kses_post( obtener_avatar_usuario( $message->author_id, 50, true ) ); ?>
        <div>
            <strong>Para:</strong><br>
            <a href="<?php echo esc_url( obtener_perfil_usuario( $message->author_id ) ); ?>">
                <?php echo esc_html( obtener_nombre_usuario( $message->author_id ) ); ?>
            </a>
        </div>
    </div>
</div>

<?php if ( get_current_user_id() === intval( $message->author_id ) ) : ?>
    <p class="notice">✉️ <strong>Escribe tu respuesta en el formulario más abajo.</strong></p>
    <h3>
        <a href="#formulario-respuesta" class="button">✏️ Responder</a>
        <a href="<?php echo esc_url( home_url( '/mensajes-de-usuario/?user_id=' . $message->sender_id ) ); ?>" style="font-size:0.8em; margin-left:15px;">Relacionados 👤</a>
    </h3>
<?php else : ?>
    <h3>
        <a href="<?php echo esc_url( home_url( '/mensajes-de-usuario/?user_id=' . $message->author_id ) ); ?>" style="font-size:0.8em; margin-left:15px;">Relacionados 👤</a>
    </h3>
<?php endif; ?>

<hr>

<?php
// Mostrar hilo: iterar mensajes
if ( ! empty( $thread ) ) {
    foreach ( array_reverse( $thread ) as $msg_item ) {

        $is_from_me = intval( $msg_item->sender_id ) === get_current_user_id();
        $author_name = $is_from_me ? 'Tú' : obtener_nombre_usuario( $msg_item->sender_id );

        $timestamp = strtotime( $msg_item->date_sent );
        $date_str = ucfirst( wp_date( 'l j \d\e F \d\e Y \a \l\a\s H:i', $timestamp ) );

        echo '<div style="border: 1px solid #f2f2f2; padding:20px; background-color: #fff; border-radius:15px; margin-bottom:18px;">';

        echo '<strong style="color:#0073aa;">' . esc_html( $author_name ) . '</strong> — ';
        echo '<small>🆔 ' . esc_html( $msg_item->id ) . ' ' . esc_html( $date_str ) . '</small><br>';
        echo '<div style="margin-top:6px;"><strong>' . wp_kses_post( wp_unslash( $msg_item->subject ) ) . '</strong></div>';

        // Botón toggle y único contenedor de mensaje (con adjuntos)
        ?>
        <a href="javascript:void(0);"
           class="btn-msg toggle-mensaje"
           data-id="<?php echo esc_attr( $msg_item->id ); ?>">
           📩 Ver
        </a>

        <div id="mensaje-<?php echo intval( $msg_item->id ); ?>"
             class="mensaje-contenido"
             style="display:none; margin-top:10px; padding:10px; border:1px solid #ccc; border-radius:8px; background:#ffffff;">

            <div style="margin-top:6px;">
                <?php echo wp_kses_post( wpautop( wp_kses_post( wp_unslash( $msg_item->message ) ) ) ); ?>
            </div>

            <?php
            // Adjuntos
            if ( ! empty( $msg_item->attachments ) ) :

                $files = array_filter( array_map( 'trim', explode( ',', $msg_item->attachments ) ) );
                if ( count( $files ) ) :

                    echo '<div class="adjuntos-contenedor" style="display:flex; flex-wrap:wrap; gap:10px; margin-top:12px;">';

                    $archivo_base_url = site_url( '/archivo-protegido/?file=' );

                    foreach ( $files as $file_name ) :

                        if ( $file_name === '' ) continue;

                        $url  = esc_url( $base_url . $file_name );
                        $url2 = esc_url( $archivo_base_url . rawurlencode( $file_name ) );
                        $ext  = strtolower( pathinfo( $file_name, PATHINFO_EXTENSION ) );

                        if ( in_array( $ext, [ 'jpg','jpeg','png','gif','webp','bmp' ], true ) ) :
                            ?>
                            <div class="archivo-item" style="width:90px; text-align:center;">
                                <a href="<?php echo $url2; ?>">
                                    <img src="<?php echo $url; ?>"
                                         alt="<?php echo esc_attr( basename( $file_name ) ); ?>"
                                         style="width:80px; height:80px; object-fit:cover; border:1px solid #ccc; border-radius:4px; display:block; margin:0 auto;">
                                </a>
                                <div class="archivo-nombre" style="font-size:0.8em; margin-top:6px; word-break:break-word;">
                                    <?php echo esc_html( basename( $file_name ) ); ?>
                                </div>
                            </div>
                            <?php
                        else :
                            $icon = '📄';
                            if ( $ext === 'pdf' ) $icon = '📕';
                            elseif ( in_array( $ext, [ 'doc','docx' ], true ) ) $icon = '📝';
                            elseif ( in_array( $ext, [ 'xls','xlsx' ], true ) ) $icon = '📊';
                            elseif ( in_array( $ext, [ 'zip','rar' ], true ) ) $icon = '🗜️';
                            elseif ( $ext === 'mp3' ) $icon = '🎵';
                            elseif ( $ext === 'mp4' ) $icon = '🎞️';
                            elseif ( $ext === 'rvt' ) $icon = '🧱';
                            elseif ( $ext === 'dwg' ) $icon = '📐';
                            ?>
                            <div class="archivo-item" style="width:90px; text-align:center;">
                                <a href="<?php echo $url2; ?>" style="font-size:2em; display:inline-block; line-height:1;">
                                    <?php echo wp_kses_post( $icon ); ?>
                                </a>
                                <div class="archivo-nombre" style="font-size:0.8em; margin-top:6px; word-break:break-word;">
                                    <?php echo esc_html( basename( $file_name ) ); ?>
                                </div>
                            </div>
                            <?php
                        endif;

                    endforeach;

                    echo '</div>'; // cierre adjuntos-contenedor

                endif;

            endif;
            ?>

        </div> <!-- /mensaje-ID -->

        <?php
        // Cerrar contenedor del mensaje individual
        echo '</div>'; // cierre del .border card que abrimos al inicio del loop
    } // end foreach thread
} // end if thread not empty
?>

            <?php if ( get_current_user_id() === intval( $message->author_id ) ) : ?>

                <div id="formulario-respuesta" style="position: relative; top: -160px;"></div>
                <h3>✏️ Responder mensaje <a href="#mensaje" style="font-size: 0.8em; margin-left: 15px;">↑ Volver al mensaje</a></h3>

                <form method="post" enctype="multipart/form-data">

                    <input type="hidden" name="author_id" value="<?php echo esc_attr( $message->sender_id ); ?>">
                    <input type="hidden" name="message_id" value="<?php echo esc_attr($message->id); ?>">
                    <input type="hidden" name="conversation_id" value="<?php echo esc_attr($message->conversation_id); ?>">

                    <?php wp_nonce_field( 'send_author_message_action', 'send_author_message_nonce' ); ?>

                    <p>
                        <label for="subject">
                            <?php echo "<p style='color:green;'>🆔 " . esc_html($message_id+1) ;?>
                            Asunto:</label><br>
                        <input type="text" name="subject" required style="width:100%;" value="<?php echo esc_attr( $reply_subject_prefill ); ?>">
                    </p>

                    <p>
                        <?php
                        wp_enqueue_editor();
                        wp_editor( '', 'message', [
                            'media_buttons' => true,
                            'textarea_name' => 'message',
                            'textarea_rows' => 6,
                            'teeny'   	=> true,
                            'quicktags' 	=> true,
                        ] );
                        ?>
                    </p>

                    <p>
                        <label for="attachments">Adjuntar archivos (máx:1, tamaño max.:2 Mb.):</label><br>
                        <small style="color: #28a745; font-size: 0.9em; display: block; margin-bottom: 8px;">
                            <b>Tipos</b> de archivos admitidos:<br>
                            jpg, jpeg, png, gif (imágenes)<br>
                            pdf (documentos)<br>
                        </small>

                        <input type="file"  name="attachments[]" id="file-input" multiple />
                        <div id="preview-container"></div>
                    </p>

                    <p><input type="submit" name="send_author_message" class="button button-primary" value="Enviar respuesta"></p>

                </form>

            <?php endif; ?>

        </div> <!-- .bp-feedback -->
    </div> <!-- .container -->
</div> <!-- #buddypress -->

<?php get_footer(); ?>

<?php
// Límite dinámico para JS — usa tu función existente si la tienes
$limits = function_exists('mi_mensaje_get_upload_limits') ? mi_mensaje_get_upload_limits() : array(
    'max_files' => 3,
    'max_total_mb' => 2,
    'allowed_ext' => array('jpg','jpeg','png','gif','pdf'),
);
?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle mensajes (botones .toggle-mensaje)
    document.querySelectorAll('.toggle-mensaje').forEach(function(btn){
        btn.addEventListener('click', function(e){
            e.preventDefault();
            var id = btn.dataset.id;
            var contenido = document.getElementById('mensaje-' + id);
            if (!contenido) return;
            if (contenido.style.display === 'none' || contenido.style.display === '') {
                contenido.style.display = 'block';
                btn.innerHTML = "❌ Cerrar mensaje";
            } else {
                contenido.style.display = 'none';
                btn.innerHTML = "📩 Ver";
            }
        });
    });

    // Validación de adjuntos en el formulario (si existe)
    const inputFiles = document.querySelector('input[name="attachments[]"]');
    if (inputFiles) {
        const maxFiles = <?php echo (int) $limits['max_files']; ?>;
        const maxTotalSizeMB = <?php echo (int) $limits['max_total_mb']; ?>;
        const allowedExtensions = <?php echo json_encode($limits['allowed_ext']); ?>;
        const maxTotalSizeBytes = maxTotalSizeMB * 1024 * 1024;

        inputFiles.addEventListener('change', function() {
            if (this.files.length > maxFiles) {
                alert(`Solo puedes subir hasta ${maxFiles} archivos.`);
                this.value = '';
                return;
            }

            let totalSize = 0;
            for (let i = 0; i < this.files.length; i++) {
                const file = this.files[i];
                const ext = file.name.split('.').pop().toLowerCase();
                if (!allowedExtensions.includes(ext)) {
                    alert(`El archivo "${file.name}" no está permitido.`);
                    this.value = '';
                    return;
                }
                if (file.size > maxTotalSizeBytes) {
                    alert(`El archivo "${file.name}" es demasiado grande.`);
                    this.value = '';
                    return;
                }
                totalSize += file.size;
            }

            if (totalSize > maxTotalSizeBytes) {
                alert(`El tamaño total de los archivos no puede superar ${maxTotalSizeMB} MB.`);
                this.value = '';
            }
        });
    }

    // Preview simple de archivos seleccionados
    var fileInput = document.getElementById('file-input');
    var previewContainer = document.getElementById('preview-container');
    if (fileInput && previewContainer) {
        fileInput.addEventListener('change', function(event) {
            previewContainer.innerHTML = '';
            var files = event.target.files;
            for (var i = 0; i < files.length; i++) {
                (function(file){
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        var div = document.createElement('div');
                        div.className = 'file-preview';
                        if (file.type.startsWith('image/')) {
                            var img = document.createElement('img');
                            img.src = e.target.result;
                            img.alt = file.name;
                            img.style.maxWidth = '120px';
                            img.style.maxHeight = '120px';
                            div.appendChild(img);
                        } else {
                            var p = document.createElement('p');
                            p.textContent = file.name;
                            div.appendChild(p);
                        }
                        previewContainer.appendChild(div);
                    };
                    reader.readAsDataURL(file);
                })(files[i]);
            }
        });
    }
});
</script>
