<?php
/**
 * Template Name: Mensajes Enviados
 */

if ( ! is_user_logged_in() ) {
    wp_redirect( home_url( '/wp-login.php' ) );
    exit;
}

defined( 'ABSPATH' ) || exit;
global $wpdb;

/* =========================================================
 * 6) Mover a papelera
 * ========================================================= */
if ( isset( $_POST['mover_a_papelera'], $_POST['mensaje_id'] ) ) {
    $mensaje_id = intval( $_POST['mensaje_id'] );

    if ( wp_verify_nonce( $_POST['_wpnonce'], 'mover_a_papelera_' . $mensaje_id ) ) {

        $tabla = $wpdb->prefix . 'author_messages';

        // Marcar mensaje como "en papelera"
        $wpdb->update(
            $tabla,
            array( 'papelera' => 1 ),
            array( 'id' => $mensaje_id ),
            array( '%d' ),
            array( '%d' )
        );

        wp_safe_redirect( add_query_arg( 'papelera', 'ok', get_permalink() ) );
        exit;
    }
}

/* =========================================================
 * Paginación
 * ========================================================= */
$posts_per_page = 5;
$paged          = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;

if ( ! $paged && get_query_var( 'page' ) ) {
    $paged = absint( get_query_var( 'page' ) );
}
if ( $paged < 1 ) {
    $paged = 1;
}

$offset          = ( $paged - 1 ) * $posts_per_page;
$current_user_id = get_current_user_id();
$tabla           = $wpdb->prefix . 'author_messages';

$total_items = $wpdb->get_var(
    $wpdb->prepare(
        "SELECT COUNT(*) 
         FROM {$tabla}
         WHERE sender_id = %d
           AND propietario_id = %d
           AND papelera = 0",
        $current_user_id,
        $current_user_id
    )
);

$total_pages = ceil( $total_items / $posts_per_page );

/* =========================================================
 * Mensajes enviados
 * ========================================================= */
$sql = $wpdb->prepare(
    "SELECT * FROM {$tabla}
     WHERE sender_id = %d
       AND propietario_id = %d
       AND es_remitente = 1
       AND papelera = 0
     ORDER BY date_sent DESC
     LIMIT %d, %d",
    $current_user_id,
    $current_user_id,
    $offset,
    $posts_per_page
);

$sent = $wpdb->get_results( $sql );

/* =========================================================
 * HEADER
 * ========================================================= */
get_header();
?>

<link rel="stylesheet" type="text/css"
href="<?php echo esc_url( plugins_url( 'assets/css/plugin-style.css', dirname( __FILE__ ) ) ); ?>">

<div id="buddypress">
    <div class="entry-content">

        <h3 class="mensajes-titulo">
            <span class="titulo">📤 Enviados</span>
            <span class="menu-links">
                <a href="<?php echo esc_url( home_url( '/mensajes/' ) ); ?>" class="papelera">
                    <svg viewBox="0 0 24 24"><path d="M14 5l7 7-7 7M21 12H3"/></svg>
                    Recibidos
                </a>
                <a href="<?php echo esc_url( home_url( '/papelera/' ) ); ?>" class="papelera">
                    <svg viewBox="0 0 24 24"><path d="M3 6h18M8 6v14h8V6m-5-3h2a1 1 0 0 1 1 1v2H7V4a1 1 0 0 1 1-1z"/></svg>
                    Papelera
                </a>
                <a href="<?php echo esc_url( home_url( '/redactar/' ) ); ?>" class="redactar">
                    <svg viewBox="0 0 24 24"><path d="M12 20h9"/><path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19l-4 1 1-4z"/></svg>
                    Redactar
                </a>
            </span>
        </h3>

        <!-- ====================== PAGINACIÓN ====================== -->
        <?php if ( $total_pages > 1 ) : ?>
            <nav class="pagination" style="text-align:center; margin:30px 0;">
                <?php
                if ( $paged > 1 ) {
                    $prev_link = add_query_arg( 'paged', $paged - 1 );
                    echo '<a href="' . esc_url( $prev_link ) . '" style="margin-right:15px;">« Anterior</a>';
                }

                for ( $i = 1; $i <= $total_pages; $i++ ) {
                    if ( $i === $paged ) {
                        echo '<strong style="margin:0 8px;">' . esc_html( $i ) . '</strong>';
                    } else {
                        $page_link = add_query_arg( 'paged', $i );
                        echo '<a href="' . esc_url( $page_link ) . '" style="margin:0 8px;">' . esc_html( $i ) . '</a>';
                    }
                }

                if ( $paged < $total_pages ) {
                    $next_link = add_query_arg( 'paged', $paged + 1 );
                    echo '<a href="' . esc_url( $next_link ) . '" style="margin-left:15px;">Siguiente »</a>';
                }
                ?>
            </nav>
        <?php endif; ?>

        <!-- ====================== LISTA DE MENSAJES ====================== -->
        <?php if ( $sent ) : ?>
            <div class="message-list">

                <?php foreach ( $sent as $msg ) : ?>

                    <?php
                    // Destinatario
                    $recipient = get_userdata( $msg->author_id );
                    if ( ! $recipient ) {
                        continue;
                    }

                    $recipient_id = intval( $recipient->ID );

                    // Avatar + perfil BP o WP
                    if ( function_exists( 'bp_core_fetch_avatar' ) ) {
                        $avatar       = bp_core_fetch_avatar(
                            array(
                                'item_id' => $recipient_id,
                                'type'    => 'thumb',
                                'html'    => true,
                            )
                        );
                        $profile_link = bp_core_get_user_domain( $recipient_id );
                    } else {
                        $avatar       = get_avatar( $recipient_id, 50 );
                        $user         = get_userdata( $recipient_id );
                        $profile_link = $user ? home_url( '/perfil/' . $user->user_nicename . '/' ) : home_url( '/' );
                    }

                    $related_url = home_url( '/mensajes-de-usuario/?user_id=' . $recipient_id );

                    $clase_leido  = ( intval( $msg->leido ) === 0 ) ? 'unread' : 'read';
                    ?>

                    <div class="message-item <?php echo esc_attr( $clase_leido ); ?>">
                        <div class="message-avatar">

                            <a href="<?php echo esc_url( $profile_link ); ?>">
                                <?php 
                                echo $avatar; 
                                // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                ?>
                            </a>
                        </div>

                        <div class="message-content">

                            <small>
                                <p style='color:green;'>🆔 <?php echo esc_html( $msg->id ); ?>
                                <strong>Fecha:</strong>
                                <?php echo esc_html( date( 'd/m/Y H:i', strtotime( $msg->date_sent ) ) ); ?>
                                <strong>Para:</strong>
                                <a href="<?php echo esc_url( $profile_link ); ?>">
                                    <?php echo esc_html( $recipient->display_name ); ?>
                                </a>
                                <strong>Leído:</strong>
                                <?php echo esc_html( date( 'd/m/Y H:i', strtotime( $msg->fecha_leido ) ) ); ?>
                            </small>

                            <br>

                            <a href="<?php echo esc_url( home_url( '/mensaje/?mensaje_id=' . $msg->id ) ); ?>">
                                <?php if ( intval( $msg->leido ) === 0 ) : ?>
                                    <strong>
                                        <span style="color:#c00;">✉️ No leído</span>
                                        Asunto:
                                        <?php echo esc_html( $msg->subject ); ?>
                                    </strong>
                                <?php else : ?>
                                    <span style="color:#090;">📬 Leído</span>
                                    Asunto:
                                    <?php echo esc_html( $msg->subject ); ?>
                                <?php endif; ?>
                            </a>

                            <div class="mensaje-acciones">

                                <!-- Ver -->
                                <a href="javascript:void(0);" onclick="toggleMensaje(<?php echo esc_attr( $msg->id ); ?>)"
                                   class="btn-msg btn-ver">
                                    📩 Ver
                                </a>

                                <div id="mensaje-<?php echo esc_attr( $msg->id ); ?>"
                                     class="mensaje-contenido"
                                     style="display:none; margin-top:10px; padding:10px; border:1px solid #ccc; border-radius:8px;background:#ffffff;">
                                    <?php
                                    echo wpautop( wp_kses_post( $msg->message ) );
                                    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                    ?>

                                    <?php
                                    $miniaturas = mostrar_miniaturas( $msg->attachments );
                                    if ( ! empty( $miniaturas ) ) {
                                        echo '<br>Archivos adjuntos:';
                                        echo $miniaturas;
                                        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                    }
                                    ?>
                                </div>

                                <!-- Relacionados -->
                                <a href="<?php echo esc_url( $related_url ); ?>" class="btn-msg btn-rel">
                                    👤 Relacionados
                                </a>

                                <!-- Form papelera -->
                                <form id="papelera-form-<?php echo esc_attr( $msg->id ); ?>"
                                      method="post"
                                      action="<?php echo esc_url( get_permalink() ); ?>"
                                      style="display:none;">
                                    <input type="hidden" name="mensaje_id" value="<?php echo esc_attr( $msg->id ); ?>">
                                    <?php wp_nonce_field( 'mover_a_papelera_' . $msg->id ); ?>
                                    <input type="hidden" name="mover_a_papelera" value="1">
                                </form>

                                <!-- Botón papelera -->
                                <a href="javascript:void(0);"
                                   class="btn-msg btn-papelera"
                                   onclick="document.getElementById('papelera-form-<?php echo esc_attr( $msg->id ); ?>').submit();">
                                    🗑️ Mover a la papelera
                                </a>

                                <!-- Leer -->
                                <a href="<?php echo esc_url( home_url( '/mensaje/?mensaje_id=' . $msg->id ) ); ?>"
                                   class="btn-msg btn-contestar">
                                    ➡️Leer
                                </a>

                            </div>
                        </div>
                    </div>

                <?php endforeach; ?>
            </div>

        <?php else : ?>

            <p><?php echo esc_html__( 'No tienes mensajes enviados.', 'mi-mensaje-plugin' ); ?></p>

        <?php endif; ?>

    </div>
</div>

<?php get_footer(); ?>

<script>
function toggleMensaje(id) {
    const contenido = document.getElementById('mensaje-' + id);
    contenido.style.display = (contenido.style.display === 'none') ? 'block' : 'none';
}
</script>
