<?php
/**
 * Template Name: Mensajes de usuario
 */

if ( ! is_user_logged_in() ) {
    wp_redirect( home_url( '/wp-login.php' ) );
    exit;
}

require_once MI_MENSAJE_PLUGIN_DIR . 'includes/functions-core.php';

global $wpdb;
$table = $wpdb->prefix . 'author_messages';

// ------------------------------
// Procesar formulario "Mover a papelera"
// ------------------------------
if ( isset( $_POST['mover_a_papelera'], $_POST['mensaje_id'] ) ) {

    $mensaje_id     = intval( $_POST['mensaje_id'] );
    $tabla_mensajes = $wpdb->prefix . 'author_messages';

    if ( ! isset( $_POST['_wpnonce'] ) || ! wp_verify_nonce( $_POST['_wpnonce'], 'mover_a_papelera_' . $mensaje_id ) ) {
        wp_die( 'Acción no permitida.' );
    }

    $resultado = $wpdb->update(
        $tabla_mensajes,
        array( 'papelera' => 1 ),
        array( 'id' => $mensaje_id ),
        array( '%d' ),
        array( '%d' )
    );

    if ( $resultado !== false ) {
        wp_safe_redirect( add_query_arg( 'papelera', 'ok', wp_get_referer() ) );
        exit;
    } else {
        wp_safe_redirect( add_query_arg( 'papelera', 'error', wp_get_referer() ) );
        exit;
    }
}

// ------------------------------
// Validar user_id
// ------------------------------
$user_id = isset( $_GET['user_id'] ) ? intval( $_GET['user_id'] ) : 0;
if ( $user_id === 0 ) {
    echo '<p style="color:red;">Error: No se ha especificado el ID del usuario.</p>';
    return;
}

// ------------------------------
// Datos del usuario: nombre, avatar y perfil
// ------------------------------
$user_info = get_userdata( $user_id );
$user_name = $user_info ? $user_info->display_name : 'Usuario';

if ( function_exists( 'bp_core_fetch_avatar' ) ) {
    // BuddyPress: bp_core_fetch_avatar devuelve HTML
    $avatar_raw = bp_core_fetch_avatar( array(
        'item_id' => $user_id,
        'type'    => 'thumb',
        'html'    => true,
    ) );
    // Limitar atributos permitidos en la etiqueta img
    $avatar = wp_kses(
        $avatar_raw,
        array(
            'img' => array(
                'src'    => array(),
                'class'  => array(),
                'alt'    => array(),
                'width'  => array(),
                'height' => array(),
            ),
        )
    );

    $profile_link_raw = bp_core_get_user_domain( $user_id );
    $profile_link     = $profile_link_raw ? esc_url( $profile_link_raw ) : esc_url( home_url( '/' ) );

} else {
    // Sin BuddyPress
    $avatar_raw = get_avatar( $user_id, 50 );
    $avatar = wp_kses(
        $avatar_raw,
        array(
            'img' => array(
                'src'    => array(),
                'class'  => array(),
                'alt'    => array(),
                'width'  => array(),
                'height' => array(),
            ),
        )
    );

    $user_tmp = get_userdata( $user_id );
    if ( $user_tmp ) {
        $profile_link = esc_url( home_url( '/perfil/' . $user_tmp->user_nicename . '/' ) );
    } else {
        $profile_link = esc_url( home_url( '/' ) );
    }
}

// ------------------------------
// Consultas: recibidos y enviados
// ------------------------------
$current_user_id = get_current_user_id();

$mensajes_recibidos = $wpdb->get_results(
    $wpdb->prepare(
        "SELECT * FROM {$table}
         WHERE sender_id = %d
           AND author_id = %d
           AND papelera = 0
           AND propietario_id = author_id
         ORDER BY id DESC",
        $user_id,
        $current_user_id
    )
);

$mensajes_enviados = $wpdb->get_results(
    $wpdb->prepare(
        "SELECT * FROM {$table}
         WHERE author_id = %d
           AND sender_id = %d
           AND papelera = 0
           AND propietario_id = sender_id
         ORDER BY id DESC",
        $user_id,
        $current_user_id
    )
);

?>
<link rel="stylesheet" type="text/css" href="<?php echo esc_url( plugins_url( 'assets/css/plugin-style.css', dirname( __FILE__ ) ) ); ?>">

<?php get_header(); ?>

<?php
// Mensajes de estado papelera
if ( isset( $_GET['papelera'] ) ) {
    if ( $_GET['papelera'] === 'ok' ) {
        echo '<div style="color:green; margin:10px 0; font-weight:bold;">🗑️ El mensaje se ha movido a la papelera.</div>';
    } elseif ( $_GET['papelera'] === 'error' ) {
        echo '<div style="color:red; margin:10px 0; font-weight:bold;">⚠️ No se ha podido mover el mensaje.</div>';
    }
}
?>

<div id="buddypress">
    <div class="entry-content">

        <h3 class="mensajes-titulo">
            <span class="titulo">👤 Relacionados</span>
            <span class="menu-links">
                <a href="<?php echo esc_url( home_url( '/mensajes/' ) ); ?>" class="recibidos">
                    <svg viewBox="0 0 24 24"><path d="M14 5l7 7-7 7M21 12H3"/></svg>
                    Recibidos
                </a>

                <a href="<?php echo esc_url( home_url( '/mensajes-enviados/' ) ); ?>" class="enviados">
                    <svg viewBox="0 0 24 24"><path d="M14 5l7 7-7 7M21 12H3"/></svg>
                    Enviados
                </a>

                <a href="<?php echo esc_url( home_url( '/papelera/' ) ); ?>" class="papelera">
                    <svg viewBox="0 0 24 24"><path d="M3 6h18M8 6v14h8V6m-5-3h2a1 1 0 0 1 1 1v2H7V4a1 1 0 0 1 1-1z"/></svg>
                    Papelera
                </a>
            </span>
        </h3>

		<?php 
		// El avatar ya viene saneado por BuddyPress. 
		echo $avatar; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		?>


        <p>Mensajes relacionados con <strong><?php echo esc_html( $user_name ); ?></strong></p>

        <!-- ================= RECIBIDOS ================= -->
        <h3 id="recibidos" class="recibidos">📥 Recibidos
            <a href="#enviados" style="font-size: 0.8em; margin-left: 15px;">Ver enviados ↓</a>
        </h3>

        <?php if ( $mensajes_recibidos ) : ?>
            <div class="mensajes-recibidos-list">
                <?php foreach ( $mensajes_recibidos as $msg ) : 
                    $leido = intval( $msg->leido ) === 0;
                    $fondo = $leido ? '#f2f2f2' : '#fff';
                ?>
                    <div class="mensaje-item" style="background-color: <?php echo esc_attr( $fondo ); ?>;">

                        <small>
                            <strong>Fecha:</strong>
                            <?php echo esc_html( date( 'd/m/Y H:i', strtotime( $msg->date_sent ) ) ); ?>
                        </small>
                        <br>

                        <a href="<?php echo esc_url( site_url( '/mensaje/?mensaje_id=' . intval( $msg->id ) ) ); ?>">
                            Asunto:
                            <strong>
                                <?php
                                $leido_icono = $leido ? '<span style="color:#c00;">✉️ No leído</span>' : '<span style="color:#090;">📬 Leído</span>';
                                echo wp_kses( $leido_icono, array( 'span' => array( 'style' => array() ) ) );
                                echo ' ' . esc_html( $msg->subject );
                                ?>
                            </strong>
                        </a>
                        <br>

                        <div class="mensaje-acciones">

                            <!-- Ver mensaje (usa data-id, manejado por script abajo) -->
                            <a href="#" class="btn-msg btn-ver" data-mensaje-id="<?php echo esc_attr( intval( $msg->id ) ); ?>">
                                📩 Ver mensaje
                            </a>

                            <!-- Contenido desplegable -->
                            <div id="<?php echo esc_attr( 'mensaje-' . intval( $msg->id ) ); ?>"
                                 class="mensaje-contenido"
                                 style="display:none; margin-top:10px; padding:10px; border:1px solid #ccc; border-radius:8px; background:#fff;">
							<?php 
							echo wpautop( wp_kses_post( $msg->message ) ); 
							// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
							?>



                                <?php
                                $miniaturas = mostrar_miniaturas( $msg->attachments );
                                if ( ! empty( $miniaturas ) ) {
									echo '<div>' . esc_html__( 'Archivos adjuntos:', 'mi-mensaje-plugin' ) . '</div>';

                                    echo wp_kses(
                                        $miniaturas,
                                        array(
                                            'a'    => array( 'href' => array(), 'target' => array(), 'class' => array() ),
                                            'img'  => array( 'src' => array(), 'alt' => array(), 'class' => array(), 'width' => array(), 'height' => array() ),
                                            'div'  => array( 'class' => array(), 'style' => array() ),
                                            'span' => array( 'class' => array(), 'style' => array() ),
                                            'p'    => array(),
                                            'br'   => array(),
                                        )
                                    );
                                }
                                ?>
                            </div>

                            <!-- Form mover a papelera (oculto) -->
                            <form id="<?php echo esc_attr( 'papelera-form-' . intval( $msg->id ) ); ?>"
                                  method="post"
                                  action="<?php echo esc_url( get_permalink() ); ?>"
                                  style="display:none;">
                                <input type="hidden" name="mensaje_id" value="<?php echo esc_attr( $msg->id ); ?>">
                                <?php wp_nonce_field( 'mover_a_papelera_' . $msg->id ); ?>
                                <input type="hidden" name="mover_a_papelera" value="1">
                            </form>

                            <a href="#" class="btn-msg btn-papelera" data-form-id="<?php echo esc_attr( 'papelera-form-' . intval( $msg->id ) ); ?>">
                                🗑️ Mover a la papelera
                            </a>

                            <!-- Contestar -->
                            <a href="<?php echo esc_url( home_url( '/mensaje/?mensaje_id=' . intval( $msg->id ) ) ); ?>" class="btn-msg btn-contestar">
                                ➡️ Contestar
                            </a>

                        </div><!-- .mensaje-acciones -->

                    </div><!-- .mensaje-item -->
                <?php endforeach; ?>
            </div><!-- .mensajes-recibidos-list -->
        <?php else : ?>
            <p><?php echo esc_html__( 'No hay mensajes recibidos.', 'mi-mensaje-plugin' ); ?></p>
			
        <?php endif; ?>

        <br><br><br>

        <!-- ================= ENVIADOS ================= -->
        <h3 id="enviados">📤 Enviados <a href="#recibidos" style="font-size: 0.8em; margin-left: 15px;">↑ Volver a recibidos</a></h3>

        <?php if ( $mensajes_enviados ) : ?>
            <div class="mensajes-enviados-list">
                <?php foreach ( $mensajes_enviados as $msg ) :
                    $leido_e = intval( $msg->leido ) === 0;
                    $fondo_e = $leido_e ? '#f2f2f2' : '#fff';
                ?>
                    <div class="mensaje-item" style="background-color: <?php echo esc_attr( $fondo_e ); ?>;">

                        <small>
                            <strong>Fecha:</strong>
                            <?php echo esc_html( date( 'd/m/Y H:i', strtotime( $msg->date_sent ) ) ); ?>
                        </small>
                        <br>

                        <a href="<?php echo esc_url( site_url( '/mensaje/?mensaje_id=' . intval( $msg->id ) ) ); ?>">
                            Asunto:
                            <strong>
                                <?php
                                $leido_icono_e = $leido_e ? '<span style="color:#c00;">✉️ No leído</span>' : '<span style="color:#090;">📬 Leído</span>';
                                echo wp_kses( $leido_icono_e, array( 'span' => array( 'style' => array() ) ) );
                                echo ' ' . esc_html( $msg->subject );
                                ?>
                            </strong>
                        </a>
                        <br>
                        <div class="mensaje-acciones">

                            <!-- Ver mensaje (enviados) -->
                            <a href="#" class="btn-msg btn-ver2" data-mensaje2-id="<?php echo esc_attr( intval( $msg->id ) ); ?>">
                                📩 Ver mensaje
                            </a>

                            <div id="<?php echo esc_attr( 'mensaje2-' . intval( $msg->id ) ); ?>"
								 
								 
                                 class="mensaje-contenido"
                                 style="display:none; border:1px solid #ccc; border-radius:8px; background:#fff; padding:10px; margin-top:10px;">

								<?php 
								echo wpautop( wp_kses_post( $msg->message ) ); 
								// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
								?>

								
                                <?php
                                $miniaturas_e = mostrar_miniaturas( $msg->attachments );
                                if ( ! empty( $miniaturas_e ) ) {
                                    echo '<div>' . esc_html__( 'Archivos adjuntos:', 'mi-mensaje-plugin' ) . '</div>';
                                    echo wp_kses(
                                        $miniaturas_e,
                                        array(
                                            'a'    => array( 'href' => array(), 'target' => array(), 'class' => array() ),
                                            'img'  => array( 'src' => array(), 'alt' => array(), 'class' => array(), 'width' => array(), 'height' => array() ),
                                            'div'  => array( 'class' => array(), 'style' => array() ),
                                            'span' => array( 'class' => array(), 'style' => array() ),
                                            'p'    => array(),
                                            'br'   => array(),
                                        )
                                    );
                                }
                                ?>
                            </div>

                            <!-- Form mover a papelera -->
                            <form id="<?php echo esc_attr( 'papelera-form-' . intval( $msg->id ) ); ?>"
                                  method="post"
                                  action="<?php echo esc_url( get_permalink() ); ?>"
                                  style="display:none;">
                                <input type="hidden" name="mensaje_id" value="<?php echo esc_attr( $msg->id ); ?>">
                                <?php wp_nonce_field( 'mover_a_papelera_' . $msg->id ); ?>
                                <input type="hidden" name="mover_a_papelera" value="1">
                            </form>

                            <a href="#" class="btn-msg btn-papelera" data-form-id="<?php echo esc_attr( 'papelera-form-' . intval( $msg->id ) ); ?>">
                                🗑️ Mover a la papelera
                            </a>

                            <!-- Leer -->
                            <a href="<?php echo esc_url( home_url( '/mensaje/?mensaje_id=' . intval( $msg->id ) ) ); ?>" class="btn-msg btn-contestar">
                                ➡️ Leer
                            </a>

                        </div><!-- .mensaje-acciones -->

                    </div><!-- .mensaje-item -->
                <?php endforeach; ?>
            </div><!-- .mensajes-enviados-list -->
        <?php else : ?>
            <p><?php echo esc_html__( 'No hay mensajes enviados.', 'mi-mensaje-plugin' ); ?></p>
        <?php endif; ?>

        <h4><a href="<?php echo esc_url( home_url( '/mensajes' ) ); ?>" class="button">← Volver a mis mensajes</a></h4>

    </div>
</div>

<?php get_footer(); ?>

<!-- JavaScript: event listeners en lugar de inline onclick (WPCS-friendly) -->
<script>
document.addEventListener('DOMContentLoaded', function () {

    // Toggle mensajes recibidos
    document.querySelectorAll('.btn-ver[data-mensaje-id]').forEach(function (btn) {
        btn.addEventListener('click', function (e) {
            e.preventDefault();
            var id = this.getAttribute('data-mensaje-id');
            var contenido = document.getElementById('mensaje-' + id);
            if ( contenido ) {
                contenido.style.display = (contenido.style.display === 'none') ? 'block' : 'none';
            }
        });
    });

    // Toggle mensajes enviados
    document.querySelectorAll('.btn-ver2[data-mensaje2-id]').forEach(function (btn) {
        btn.addEventListener('click', function (e) {
            e.preventDefault();
            var id = this.getAttribute('data-mensaje2-id');
            var contenido = document.getElementById('mensaje2-' + id);
            if ( contenido ) {
                contenido.style.display = (contenido.style.display === 'none') ? 'block' : 'none';
            }
        });
    });

    // Mover a papelera (submit del formulario oculto)
    document.querySelectorAll('.btn-papelera[data-form-id]').forEach(function (btn) {
        btn.addEventListener('click', function (e) {
            e.preventDefault();
            var formId = this.getAttribute('data-form-id');
            var form = document.getElementById(formId);
            if ( form ) form.submit();
        });
    });

});
</script>
