<?php
/**
 * Template Name: mis mensajes
 */

if ( ! is_user_logged_in() ) {
    wp_redirect( home_url( '/wp-login.php' ) );
    exit;
}

defined( 'ABSPATH' ) || exit;
global $wpdb;


// 6) Mover a papelera
if ( isset( $_POST['mover_a_papelera'], $_POST['mensaje_id'] ) ) {
    $mensaje_id = intval( $_POST['mensaje_id'] );

    if ( wp_verify_nonce( $_POST['_wpnonce'], 'mover_a_papelera_' . $mensaje_id ) ) {
        global $wpdb;
        $tabla = $wpdb->prefix . 'author_messages';

        // Marcar mensaje como "en papelera"
        $wpdb->update(
            $tabla,
            array( 'papelera' => 1 ),
            array( 'id' => $mensaje_id ),
            array( '%d' ),
            array( '%d' )
        );

        // Redirigir para evitar reenvíos por F5
        wp_safe_redirect( add_query_arg( 'papelera', 'ok', get_permalink() ) );
        exit;
    }
}


// 0) Cuántos mensajes por página
$posts_per_page = 5;

// 1) Recoger la página actual de WordPress
$paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
if ( ! $paged && get_query_var( 'page' ) ) {
    $paged = absint( get_query_var( 'page' ) );
}
if ( $paged < 1 ) {
    $paged = 1;
}

// 2) Calcular OFFSET
$offset = ( $paged - 1 ) * $posts_per_page;

// 3) Contar total de mensajes para este usuario (papelera = 0)
$current_user_id = get_current_user_id();
$tabla           = $wpdb->prefix . 'author_messages';

$total_items = $wpdb->get_var(
    $wpdb->prepare(
        "SELECT COUNT(*)
         FROM {$tabla}
         WHERE author_id = %d
           AND propietario_id = %d
           AND papelera = 0",
        $current_user_id,
        $current_user_id
    )
);

// 4) Calcular total de páginas
$total_pages = ceil( $total_items / $posts_per_page );

// 5) Obtener únicamente los mensajes de esta página
$sql = $wpdb->prepare(
    "SELECT *
     FROM {$tabla}
     WHERE author_id = %d
       AND propietario_id = %d
       AND es_remitente = 0
       AND papelera = 0
     ORDER BY date_sent DESC
     LIMIT %d, %d",
    $current_user_id,
    $current_user_id,
    $offset,
    $posts_per_page
);

$mensajes = $wpdb->get_results($sql);

// 6) Cargar encabezado del tema
get_header();
?>

<link rel="stylesheet" type="text/css"
href="<?php echo esc_url( plugins_url( 'assets/css/plugin-style.css', dirname( __FILE__ ) ) ); ?>">

<div id="buddypress">
    <div class="entry-content">

<h3 class="mensajes-titulo">
  <span class="titulo">📥 Recibidos</span>
  <span class="menu-links">
    <a href="<?php echo esc_url( home_url( '/mensajes-enviados/' ) ); ?>" class="enviados">
      <svg viewBox="0 0 24 24"><path d="M14 5l7 7-7 7M21 12H3"/></svg>
      Enviados
    </a>
    <a href="<?php echo esc_url( home_url( '/papelera/' ) ); ?>" class="papelera">
      <svg viewBox="0 0 24 24"><path d="M3 6h18M8 6v14h8V6m-5-3h2a1 1 0 0 1 1 1v2H7V4a1 1 0 0 1 1-1z"/></svg>
      Papelera
    </a>
    <a href="<?php echo esc_url( home_url( '/redactar/' ) ); ?>" class="redactar">
      <svg viewBox="0 0 24 24"><path d="M12 20h9"/><path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19l-4 1 1-4z"/></svg>
      Redactar
    </a>
  </span>
</h3>

<!-- Paginación superior -->
<?php if ( $total_pages > 1 ) : ?>
    <nav class="pagination" style="text-align:center; margin:30px 0;">
        <?php
        if ( $paged > 1 ) {
            $prev_link = add_query_arg( 'paged', $paged - 1 );
            echo '<a href="' . esc_url( $prev_link ) . '" style="margin-right:15px;">« Anterior</a>';
        }

        for ( $i = 1; $i <= $total_pages; $i++ ) {
            if ( $i === $paged ) {
                echo '<strong style="margin:0 8px;">' . esc_html( $i ) . '</strong>';
            } else {
                $page_link = add_query_arg( 'paged', $i );
                echo '<a href="' . esc_url( $page_link ) . '" style="margin:0 8px;">' . esc_html( $i ) . '</a>';
            }
        }

        if ( $paged < $total_pages ) {
            $next_link = add_query_arg( 'paged', $paged + 1 );
            echo '<a href="' . esc_url( $next_link ) . '" style="margin-left:15px;">Siguiente »</a>';
        }
        ?>
    </nav>
<?php endif; ?>

<?php if ( $mensajes ) : ?>
    <div class="message-list">

<?php foreach ( $mensajes as $msg ) :

    $sender = get_userdata( $msg->sender_id );
    if ( ! $sender ) continue;

    // Avatar
    if ( function_exists( 'bp_core_fetch_avatar' ) ) {
        $avatar = bp_core_fetch_avatar([
            'item_id' => $sender->ID,
            'type'    => 'thumb',
            'html'    => true
        ]);
    } else {
        $avatar = get_avatar( $sender->ID, 50 );
    }

    $sender_id = intval( $msg->sender_id );

    // Enlace de perfil
    if ( function_exists( 'bp_core_get_user_domain' ) ) {
        $profile_link = bp_core_get_user_domain( $sender_id );
    } else {
        $profile_link = get_author_posts_url( $sender_id );
    }

    // URL relacionados
    $related_url = home_url( '/mensajes-de-usuario/?user_id=' . $sender_id );

    $clase_leido = intval( $msg->leido ) === 0 ? 'unread' : 'read';
?>
    <div class="message-item <?php echo esc_attr( $clase_leido ); ?>">

        <div class="message-avatar">
            <a href="<?php echo esc_url( $profile_link ); ?>">
                <?php echo wp_kses_post( $avatar ); ?>
            </a>
        </div>

        <div class="message-content">
            <small>
                <p style="color:green;">
                    🆔 <?php echo esc_html( $msg->id ); ?>
                    <strong>Fecha:</strong>
                    <?php echo esc_html( date( 'd/m/Y H:i', strtotime( $msg->date_sent ) ) ); ?>

                    <strong>De:</strong>
                    <a href="<?php echo esc_url( $profile_link ); ?>">
                        <?php echo esc_html( $sender->display_name ); ?>
                    </a>
                </p>
            </small>

            <?php if ( intval( $msg->leido ) === 0 ) : ?>
                <a href="<?php echo esc_url( site_url( '/mensaje/?mensaje_id=' . $msg->id ) ); ?>">
                    <strong><span style="color:#c00;">✉️ No leído</span>
                    Asunto: <?php echo esc_html( $msg->subject ); ?></strong>
                </a>
            <?php else : ?>
                <span style="color:#090;">📬 Leído</span>
                <a href="<?php echo esc_url( site_url( '/mensaje/?mensaje_id=' . $msg->id ) ); ?>">
                    Asunto: <?php echo esc_html( $msg->subject ); ?>
                </a>
            <?php endif; ?>

            <div class="mensaje-acciones">

                <!-- Ver mensaje -->
                <a href="javascript:void(0);" 
                   onclick="toggleMensaje(<?php echo esc_attr( $msg->id ); ?>)"
                   class="btn-msg btn-ver">
                    📩 Ver
                </a>

                <div id="mensaje-<?php echo esc_attr( $msg->id ); ?>" class="mensaje-contenido"
                    style="display:none; margin-top:10px; padding:10px; border:1px solid #ccc; border-radius:8px; background:#ffffff;">

                    <?php echo wp_kses_post( wpautop( $msg->message ) ); ?>

                    <?php
                    $miniaturas = mostrar_miniaturas( $msg->attachments );
                    if ( ! empty( $miniaturas ) ) {
                        //echo '<br>Archivos adjuntos: ' . wp_kses_post( $miniaturas );
						echo '<br>Archivos adjuntos:';
						echo $miniaturas;
                    }
                    ?>
                </div>

                <!-- Relacionados -->
                <a href="<?php echo esc_url( $related_url ); ?>" class="btn-msg btn-rel">
                    👤 Relacionados
                </a>

                <!-- Formulario papelera -->
                <form id="papelera-form-<?php echo esc_attr( $msg->id ); ?>"
                    method="post"
                    action="<?php echo esc_url( get_permalink() ); ?>"
                    style="display:none;">
                    <input type="hidden" name="mensaje_id" value="<?php echo esc_attr( $msg->id ); ?>">
                    <?php wp_nonce_field( 'mover_a_papelera_' . $msg->id ); ?>
                    <input type="hidden" name="mover_a_papelera" value="1">
                </form>

                <!-- Botón mover a papelera -->
                <a href="javascript:void(0);"
                    class="btn-msg btn-papelera"
                    onclick="document.getElementById('papelera-form-<?php echo esc_attr( $msg->id ); ?>').submit();">
                    🗑️ Mover a la papelera
                </a>

                <!-- Contestar -->
                <a href="<?php echo esc_url( home_url( '/mensaje/?mensaje_id=' . $msg->id ) ); ?>"
                    class="btn-msg btn-contestar">
                    ➡️ Contestar
                </a>

            </div>
        </div>
    </div>

<?php endforeach; ?>

<!-- Paginación inferior -->
<?php if ( $total_pages > 1 ) : ?>
    <nav class="pagination" style="text-align:center; margin:30px 0;">
        <?php
        if ( $paged > 1 ) {
            $prev_link = add_query_arg( 'paged', $paged - 1 );
            echo '<a href="' . esc_url( $prev_link ) . '" style="margin-right:15px;">« Anterior</a>';
        }

        for ( $i = 1; $i <= $total_pages; $i++ ) {
            if ( $i === $paged ) {
                echo '<strong style="margin:0 8px;">' . esc_html( $i ) . '</strong>';
            } else {
                $page_link = add_query_arg( 'paged', $i );
                echo '<a href="' . esc_url( $page_link ) . '" style="margin:0 8px;">' . esc_html( $i ) . '</a>';
            }
        }

        if ( $paged < $total_pages ) {
            $next_link = add_query_arg( 'paged', $paged + 1 );
            echo '<a href="' . esc_url( $next_link ) . '" style="margin-left:15px;">Siguiente »</a>';
        }
        ?>
    </nav>
<?php endif; ?>

    </div>
<?php else : ?>
    <p>No tienes mensajes recibidos.</p>
<?php endif; ?>

</div>
</div>

<?php get_footer(); ?>

<script>
function toggleMensaje(id) {
    const contenido = document.getElementById('mensaje-' + id);
    contenido.style.display = (contenido.style.display === 'none') ? 'block' : 'none';
}
</script>
