<?php
/**
 * Template Name: papelera
 */

if ( ! is_user_logged_in() ) {
    wp_redirect( home_url( '/wp-login.php' ) );
    exit;
}


defined( 'ABSPATH' ) || exit;
global $wpdb;

// Vaciar Papelera

if ( is_user_logged_in() && isset( $_POST['vaciar_papelera'] ) ) {

    $user_id    = get_current_user_id();
    $tabla      = $wpdb->prefix . 'author_messages';
    $upload_dir = wp_upload_dir();
    $base_path  = trailingslashit( $upload_dir['basedir'] ) . 'author_messages/';

    // 1. Obtener los mensajes en papelera de este usuario
    $mensajes = $wpdb->get_results(
        $wpdb->prepare(
			        "SELECT id, attachments
         FROM {$tabla}
         WHERE papelera = 1
           AND propietario_id = %d",
        $user_id
    )
);
			
				
    // 2. Procesar cada mensaje
    foreach ( $mensajes as $mensaje ) {
        $mensaje_id = intval( $mensaje->id );

        // Eliminar archivos adjuntos si existen
        if ( ! empty( $mensaje->attachments ) ) {
            $files = explode( ',', $mensaje->attachments );
            foreach ( $files as $file ) {
                $file_path = $base_path . trim( $file );
                if ( file_exists( $file_path ) ) {
                    unlink( $file_path );
                }
            }
        }

        // Borrar el mensaje
        $wpdb->delete( $tabla, [ 'id' => $mensaje_id ], [ '%d' ] );
    }

    // 3. Redirigir tras borrar todo
    wp_safe_redirect( home_url( '/papelera/' ) );
	//wp_safe_redirect( home_url( '/papelera/' ) );
    exit;
}


//Borrar cada mensaje

// 1) Procesar borrado definitivo antes de cualquier salida
if ( isset( $_POST['borrado_definitivo'] ) && ! empty( $_POST['mensaje_id'] ) ) {
    $mensaje_id = intval( $_POST['mensaje_id'] );

    // 1.a) Verificar nonce de seguridad
    if ( ! isset( $_POST['_wpnonce'] ) || ! wp_verify_nonce( $_POST['_wpnonce'], 'borrar_definitivo_' . $mensaje_id ) ) {
        wp_die( 'Error de seguridad: nonce inválido.' );
    }

    // 1.b) Obtener la lista de adjuntos desde la base de datos
    $tabla = $wpdb->prefix . 'author_messages'; // esto dará "social_author_messages"
    $adjuntos_string = $wpdb->get_var(
        $wpdb->prepare(
            "SELECT attachments FROM {$tabla} WHERE id = %d",
            $mensaje_id
        )
    );

    if ( ! empty( $adjuntos_string ) ) {
        // 1.c) Si hay adjuntos, separar por comas y borrar cada uno
        $upload_dir = wp_upload_dir();
        $base_path  = trailingslashit( $upload_dir['basedir'] ) . 'author_messages/';

        $files = explode( ',', $adjuntos_string );
        foreach ( $files as $file_name ) {
            $file_name   = trim( $file_name );
            $ruta_archivo = $base_path . $file_name;
            if ( file_exists( $ruta_archivo ) ) {
                unlink( $ruta_archivo );
            }
        }
    }

    // 1.d) Borrar el registro de la base de datos
    $wpdb->delete(
        $tabla,
        [ 'id' => $mensaje_id ],
        [ '%d' ]
    );

    // 1.e) Redirigir de nuevo a la misma página (para refrescar la lista)
    wp_safe_redirect( get_permalink() );
    exit;
}




// 1) Procesar restaurar mensaje antes de cargar HTML
if ( isset( $_POST['restaurar_mensaje'] ) && ! empty( $_POST['mensaje_id'] ) ) {
    $mensaje_id = intval( $_POST['mensaje_id'] );

    // Verificar nonce
    if ( ! isset( $_POST['_wpnonce'] ) || ! wp_verify_nonce( $_POST['_wpnonce'], 'restaurar_mensaje_' . $mensaje_id ) ) {
        wp_die( 'Error de seguridad: nonce inválido.' );
    }

    // Actualizar campo papelera = 0 (restaurar)
    $tabla = $wpdb->prefix . 'author_messages'; // "social_author_messages"
    $wpdb->update(
        $tabla,
        [ 'papelera' => 0 ],
        [ 'id' => $mensaje_id ],
        [ '%d' ],
        [ '%d' ]
    );

    // Redirigir a la misma página para refrescar la lista de la papelera
    wp_safe_redirect( get_permalink() );
    exit;
}


global $wpdb;
$current_user_id = get_current_user_id();
$tabla = $wpdb->prefix . 'author_messages';

// MENSAJES EN LA PAPELERA
$query = $wpdb->prepare(
    "SELECT * FROM $tabla
     WHERE papelera = 1
     AND (
            (author_id = %d AND propietario_id = %d)
         OR (sender_id = %d AND propietario_id = %d)
         )
     ORDER BY date_sent DESC",
    $current_user_id, // author_id
    $current_user_id, // propietario_id como author
    $current_user_id, // sender_id
    $current_user_id  // propietario_id como sender
);


	 
		 
$received = $wpdb->get_results($query);


	
// Contamos si hay mensajes en papelera para el usuario
$current_user_id = get_current_user_id();
$tabla = $wpdb->prefix . 'author_messages';

$hay_mensajes = (int) $wpdb->get_var(
    $wpdb->prepare(
        "SELECT COUNT(*)
         FROM {$tabla}
         WHERE papelera = 1
           AND (
                (author_id = %d AND propietario_id = %d)
             OR (sender_id = %d AND propietario_id = %d)
           )",
        $current_user_id, // author_id
        $current_user_id, // propietario_id como author
        $current_user_id, // sender_id
        $current_user_id  // propietario_id como sender
    )
);


// 2) Cargar el header del tema
get_header();
?>

<link rel="stylesheet" type="text/css"
href="<?php echo plugins_url( 'assets/css/plugin-style.css', dirname(__FILE__) ); ?>">





<div id="buddypress">
    <div class="entry-content">

		
<h3 class="mensajes-titulo">
  <span class="titulo">🗑️ Papelera</span>
  <span class="menu-links">

	  <a href="<?php echo esc_url( home_url( '/mensajes/' ) ); ?>" class="papelera">
      <svg viewBox="0 0 24 24"><path d="M14 5l7 7-7 7M21 12H3"/></svg>
      Recibidos
    </a>
    <a href="<?php echo esc_url( home_url( '/mensajes-enviados/' ) ); ?>" class="enviados">
      <svg viewBox="0 0 24 24"><path d="M14 5l7 7-7 7M21 12H3"/></svg>
      Enviados
    </a>
    <a href="<?php echo esc_url( home_url( '/redactar/' ) ); ?>" class="redactar">
      <svg viewBox="0 0 24 24"><path d="M12 20h9"/><path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19l-4 1 1-4z"/></svg>
      Redactar
    </a>
  </span>
</h3>

</div>	

	
		
<?php if ( $hay_mensajes > 0 ) : ?>

    <form id="vaciar-papelera-form"
          method="post"
          action="<?php echo esc_url( get_permalink() ); ?>"
          style="display:none;"
          onsubmit="return confirm('¿Estás seguro de vaciar la papelera? Se eliminarán todos los mensajes y archivos.');">
        <?php wp_nonce_field( 'vaciar_papelera' ); ?>
        <input type="hidden" name="vaciar_papelera" value="1">
    </form>

<a href="javascript:void(0);"
   class="btn-msg btn-papelera"
   onclick="
       if (confirm('¿Estás seguro de vaciar la papelera? Se eliminarán todos los mensajes y archivos.')) {
           document.getElementById('vaciar-papelera-form').submit();
       }
   ">
    🗑️ Vaciar papelera
</a>

<?php endif; ?>
			
		
	

	
	
	

<?php 
		
		if ( ! empty( $received ) ) : ?>
		
    <div class="message-list">
		
        <?php foreach ( $received as $msg ) : 
		
				$sender = get_userdata( $msg->sender_id );
				//$avatar = bp_core_fetch_avatar( array( 'item_id' => $sender->ID, 'type' => 'thumb', 'html' => true ) );
				//$profile_link = bp_core_get_user_domain( $sender->ID );
				

				// Avatar y enlace de perfil compatibles con BuddyPress
					
					if ( function_exists( 'bp_core_fetch_avatar' ) ) {
    				$avatar       = bp_core_fetch_avatar( array( 'item_id' => $sender->ID, 'type' => 'thumb', 'html' => true ) );
    				$profile_link = bp_core_get_user_domain( $sender->ID );
					} else {
    				// Si BuddyPress NO está activo
    				$avatar       = get_avatar( $sender->ID, 50 );
    				$profile_link = get_author_posts_url( $sender->ID );
					}

		
		
				
					// Obtenemos el objeto WP_User del destinatario:
					$receiver = get_userdata( intval( $msg->author_id ) );
					//$receiver = get_userdata( intval( $msg->sender_id ) );

					// Si no existe (por seguridad), caemos a vacío
					if ( ! $receiver ) {
  					  continue;
						}
				
					
					// Avatar con BuddyPress (o fallback a get_avatar)
					if ( function_exists( 'bp_core_fetch_avatar' ) ) {
   					 $avatar_html = bp_core_fetch_avatar( array(
        				'item_id' => $receiver->ID,
        				'type'    => 'thumb',
        				'html'    => true,
    				) );
					} else {
  					  // Si no tienes BuddyPress activo, usas get_avatar()
   					 $avatar_html = get_avatar( $receiver->ID, 40 );
						}

		
				    // El destinatario del mensaje (el “otro usuario”)
    				$other_id = intval( $msg->author_id );

					// Primero buscamos la página “Mensajes de usuario” por su slug
					$page = get_page_by_path( 'mensajes-de-usuario' ); 

					if ( $page ) {
    				// Si existe la página, le añadimos ?user_id=nn
    				$related_url = add_query_arg(
        			'user_id',
        			$other_id,
        			get_permalink( $page->ID )
    				);
					} else {
    				// Fallback si no encuentra la página por slug
    				$related_url = home_url( '/mensajes-de-usuario/?user_id=' . $other_id );
					}
				
                ?>
		

<div class="message-item">
	
	
    <div class="message-avatar" style="display:flex; align-items:center; gap:10px;">
        <?php
        // Aseguramos que el receptor existe
        $receiver = get_userdata( intval( $msg->author_id ) );
        if ( $receiver ) {
            // Avatar con BuddyPress (o fallback a get_avatar)
            if ( function_exists( 'bp_core_fetch_avatar' ) ) {
                $avatar_html = bp_core_fetch_avatar( array(
                    'item_id' => $receiver->ID,
                    'type'    => 'thumb',
                    'html'    => true,
                ) );
                $profile_link = bp_core_get_user_domain( $receiver->ID );
            } else {
				
				//$author_url = mimensajeplugin_get_author_link( $sender->ID );
				
                $avatar_html  = get_avatar( $receiver->ID, 40 );
                //$profile_link = get_author_posts_url( $receiver->ID );
				$profile_link = mimensajeplugin_get_author_link( $receiver->ID );
				
				$avatar_html2  = get_avatar( $sender->ID, 40 );
                //$profile_link2 = get_author_posts_url( $sender->ID );
				$profile_link2 = mimensajeplugin_get_author_link( $sender->ID );
            }

            echo 'De:<a href="' . esc_url( $profile_link2 ) . '">' . $avatar_html2 . '</a>';
			echo 'Para:<a href="' . esc_url( $profile_link ) . '">' . $avatar_html . '</a>';
			
			
        } else {
            // Si el usuario ya no existe, mostramos un avatar genérico
            echo get_avatar( 0, 40 );
        }
        ?>
    </div>


	
<div class="message-content">

<small><?php echo "<p style='color:green;'>🆔 " . esc_html( $msg->id );?>-
<?php echo date( 'd/m/Y H:i', strtotime( $msg->date_sent ) ); ?>	

                <a href="<?php echo esc_url( $profile_link ); ?>">
				<?php echo esc_html( $receiver->display_name ); ?></a>
				
				<a href="<?php echo esc_url( site_url( '/mensaje/?mensaje_id=' . $msg->id ) ); ?>">
				Asunto: <strong><?php echo esc_html( $msg->subject ); ?></strong></a></small>
		

				
<div class="mensaje-acciones">	
	
	<!-- Ver mensaje -->
<a href="javascript:void(0);" onclick="toggleMensaje(<?php echo $msg->id; ?>)" 
   class="btn-msg btn-ver">
    📩 Ver mensaje
</a>
        	<div id="mensaje-<?php echo $msg->id; ?>" class="mensaje-contenido" style="display:none; margin-top:10px; padding:10px; 				border:1px solid #ccc; border-radius:8px;">
					
			<!-- Relacionados -->
<a href="<?php echo esc_url( $related_url ); ?>" class="btn-msg btn-rel">
    👤 Relacionados
</a>		
					
<!-- Contestar -->
<a href="<?php echo esc_url( home_url( '/mensaje/?mensaje_id=' . $msg->id ) ); ?>" 
   class="btn-msg btn-contestar">
    ➡️Leer
</a>
				
					
<form id="restaurar-form-<?php echo $msg->id; ?>" 
      method="post" 
      action="<?php echo esc_url( get_permalink() ); ?>" 
      style="display:none;">
    
    <?php wp_nonce_field( 'restaurar_mensaje_' . $msg->id ); ?>

    <input type="hidden" name="mensaje_id" value="<?php echo esc_attr( $msg->id ); ?>">
    <input type="hidden" name="restaurar_mensaje" value="1">
</form>

	<a href="javascript:void(0);" 
   class="btn-msg btn-restaurar"
   onclick="document.getElementById('restaurar-form-<?php echo $msg->id; ?>').submit();">
    🔄 Restaurar
</a>
			
				
				
					
									<!-- Miniaturas adjuntas -->
				<?php //echo mostrar_adjuntos( $msg->attachments ); ?>	
				<?php
				$miniaturas = mostrar_miniaturas( $msg->attachments );
				if ( ! empty( $miniaturas ) ) {
				echo '<br>Archivos adjuntos:';
				echo $miniaturas;
				} ?>
					
				
				
            	<?php //echo wpautop( esc_html( $msg->message ) ); ?>
				<?php echo wpautop( wp_kses_post( $msg->message ) ); ?>
				</div>
					
		
		
	<form id="borrar-form-<?php echo $msg->id; ?>" 
      method="post" 
      action="<?php echo esc_url( get_permalink() ); ?>" 
      style="display:none;">

    <?php wp_nonce_field( 'borrar_definitivo_' . $msg->id ); ?>

    <input type="hidden" name="mensaje_id" value="<?php echo esc_attr( $msg->id ); ?>">
    <input type="hidden" name="borrado_definitivo" value="1">
</form>
	

<a href="javascript:void(0);" 
   class="btn-msg btn-papelera"
   onclick="if (confirm('¿Seguro que quieres borrar este mensaje de forma definitiva?')) { 
       document.getElementById('borrar-form-<?php echo $msg->id; ?>').submit(); 
   }">
    🗑️ Borrar
</a>

		


		

					
</div>
                 </div>
                </div>
                <?php endforeach; ?>
            </div>
        <?php else : ?>
            <p>No hay mensajes en la papelera.</p>
        <?php endif; ?>

      </div>  
</div>


		











<?php get_footer(); ?>

<script>
function toggleMensaje(id) {
    const contenido = document.getElementById('mensaje-' + id);
    if (contenido.style.display === 'none') {
        contenido.style.display = 'block';
    } else {
        contenido.style.display = 'none';
    }
}
</script>
