<?php

/**
 * Template Name: Redactar Mensaje
 * Descripción: Página para redactar y enviar mensajes privados usando búsqueda AJAX.
 */
if (!defined('ABSPATH')) exit;

if (!is_user_logged_in()) {
    wp_redirect(wp_login_url());
    exit;
}

get_header();

require_once MI_MENSAJE_PLUGIN_DIR . 'includes/functions-core.php';
global $wpdb;

$table_name = $wpdb->prefix . 'author_messages';

?>

<link rel="stylesheet" type="text/css"
    href="<?php echo plugins_url('assets/css/plugin-style.css', dirname(__FILE__)); ?>">



<div id="buddypress">
    <div class="entry-content">


        <h3 class="mensajes-titulo">
            <span class="titulo">✏️ Redactar</span>
            <span class="menu-links">
                <a href="<?php echo esc_url(home_url('/mensajes/')); ?>" class="recibidos">
                    <svg viewBox="0 0 24 24">
                        <path d="M14 5l7 7-7 7M21 12H3" />
                    </svg>
                    Recibidos
                </a>

                <a href="<?php echo esc_url(home_url('/mensajes-enviados/')); ?>" class="enviados">
                    <svg viewBox="0 0 24 24">
                        <path d="M14 5l7 7-7 7M21 12H3" />
                    </svg>
                    Enviados
                </a>

                <a href="<?php echo esc_url(home_url('/papelera/')); ?>" class="papelera">
                    <svg viewBox="0 0 24 24">
                        <path d="M3 6h18M8 6v14h8V6m-5-3h2a1 1 0 0 1 1 1v2H7V4a1 1 0 0 1 1-1z" />
                    </svg>
                    Papelera
                </a>

            </span>
        </h3>





        <div class="mi-redactar-mensaje" style="max-width:650px;margin:40px auto;padding:20px;background:#fff;border-radius:12px;box-shadow:0 4px 12px rgba(0,0,0,0.1);">
            <h2 style="margin-bottom:20px;">✉️ Redactar nuevo mensaje</h2>

            <?php
            if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['mi_mensaje_nonce']) && wp_verify_nonce($_POST['mi_mensaje_nonce'], 'mi_mensaje_action')) {

                $errors = [];

                // 1️⃣ Destinatario
                $recipient_login = sanitize_text_field($_POST['buscar_usuario'] ?? '');
                $recipient = get_user_by('login', $recipient_login);
                $author_id = $recipient ? $recipient->ID : 0;

                if (!$author_id) $errors[] = 'Debes seleccionar un destinatario válido.';

                // 2️⃣ Remitente
                $sender_id = get_current_user_id();

                // 3️⃣ Asunto y mensaje
                $subject = sanitize_text_field($_POST['asunto'] ?? '');
                $message = wp_kses_post($_POST['mensaje'] ?? '');
                if (!$subject) $errors[] = 'El asunto no puede estar vacío.';
                if (!$message) $errors[] = 'El mensaje no puede estar vacío.';

                // 🔹 Asunto y contenido
                $subject = sanitize_text_field($_POST['asunto'] ?? '');
                $message = wp_kses_post($_POST['mensaje'] ?? '');
                if (!$subject) $errors[] = 'El asunto no puede estar vacío.';
                if (!$message) $errors[] = 'El mensaje no puede estar vacío.';

                // 🔹 Adjuntos


                $attachments = [];
                $attachments_copy = [];
                $errors_adjuntos = [];

                if (!empty($_FILES['attachments']['name'][0])) {
                    $upload_dir = wp_upload_dir();
                    $base_dir   = trailingslashit($upload_dir['basedir']) . 'author_messages/';
                    if (!file_exists($base_dir)) mkdir($base_dir, 0755, true);

                    foreach ($_FILES['attachments']['name'] as $i => $name) {


                        if (empty($_FILES['attachments']['tmp_name'][$i])) continue;

                        $tmp_name = $_FILES['attachments']['tmp_name'][$i];
                        $filename = sanitize_file_name($name);
                        $final_name = $filename;

                        // 🔸 Validar tamaño individual
                        if ($file_size > $max_file_size) {
                            $errors_adjuntos[] = "El archivo '{$filename}' supera el tamaño máximo de 2 MB.";
                            continue;
                        }




                        // Evitar duplicados
                        $j = 1;
                        while (file_exists($base_dir . $final_name)) {
                            $ext_pos = strrpos($filename, '.');
                            $name_only = $ext_pos !== false ? substr($filename, 0, $ext_pos) : $filename;
                            $ext = $ext_pos !== false ? substr($filename, $ext_pos) : '';
                            $final_name = $name_only . '(' . $j . ')' . $ext;
                            $j++;
                        }

                        // Mover archivo
                        $dest = $base_dir . $final_name;
                        if (move_uploaded_file($tmp_name, $dest)) {
                            // Guardar nombre para el destinatario
                            $attachments[] = $final_name;

                            // Crear copia y registrar el nombre para el remitente
                            $copy_name = preg_replace('/(\.[^.]*)$/', '-copia$1', $final_name);
                            if (@copy($dest, $base_dir . $copy_name)) {
                                $attachments_copy[] = $copy_name;
                            }
                        }
                    }
                }

                // Si quieres mostrar errores:
                if (!empty($errors_adjuntos)) {
                    foreach ($errors_adjuntos as $err) {
                        echo '<div class="error">' . $err . '</div>';
                    }
                }


                // Convertir arrays en cadenas separadas por comas
                $attachments_str = implode(',', $attachments);
                $attachments_copy_str = implode(',', $attachments_copy);



                // 5️⃣ Conversation ID (misma conversación entre sender y recipient)
                $conversation_id = date('ymdHis');

                // 6️⃣ Guardar mensaje en BD


                //DESTINATARIO=1 REMITENTE=0

                if (empty($errors)) {

                    // 🔹 Insertar mensaje para el destinatario		

                    $wpdb->insert(
                        $table_name,
                        [
                            'es_remitente'   => 0,
                            'propietario_id' => $author_id,
                            'author_id' => $author_id,
                            'sender_id' => $sender_id,
                            'subject' => $subject,
                            'message' => $message,
                            'attachments' => $attachments_str,
                            'date_sent' => current_time('mysql'),
                            'leido' => 0,
                            'papelera' => 0,
                            'conversation_id' => $conversation_id
                        ],
                        ['%d', '%d', '%d', '%d', '%s', '%s', '%s', '%s', '%d', '%d', '%d']
                    );

                    // 🔹 Insertar copia para el remitente

                    $wpdb->insert(
                        $table_name,
                        [
                            'es_remitente'   => 1,
                            'propietario_id' => $sender_id,
                            'author_id' => $author_id,
                            'sender_id' => $sender_id,
                            'subject'     => $subject,
                            'message'     => $message,
                            'attachments' => $attachments_copy_str,  // archivos -copia
                            'date_sent'   => current_time('mysql'),
                            'leido'       => 0,              // Marcamos como leído por defecto
                            'papelera'    => 0,
                            'conversation_id' => $conversation_id
                        ],
                        ['%d', '%d', '%d', '%d', '%s', '%s', '%s', '%s', '%d', '%d', '%d']
                    );




                    // Enviar correo con miniaturas
                    $author_data = get_userdata($author_id);
                    $sender_data = get_userdata($sender_id);

                    $site_name = get_bloginfo('name');
                    $domain    = parse_url(get_site_url(), PHP_URL_HOST);
                    $site_label = esc_html($site_name . ' (' . $domain . ')');



                    if ($author_data && $author_data->user_email) {
                        $upload_dir = wp_upload_dir();
                        $base_url   = trailingslashit($upload_dir['baseurl']) . 'author_messages/';
                        $attachments_html = '';

                        // 🔧 Corregido: aseguramos que $attachments sea siempre un array de nombres de archivo
                        $files = [];

                        if (!empty($attachments)) {
                            if (is_string($attachments)) {
                                // Si es una cadena separada por comas
                                $files = array_map('trim', explode(',', $attachments));
                            } elseif (is_array($attachments)) {
                                // Si ya es un array (por ejemplo, desde $_FILES)
                                $files = array_map('trim', $attachments);
                            }
                        }

                        if (!empty($files)) {
                            $attachments_html .= '<hr><p><strong>Archivos adjuntos:</strong></p><div style="display:flex;flex-wrap:wrap;gap:10px;">';
                            foreach ($files as $file) {
                                if (empty($file)) continue;

                                $file_url = $base_url . $file;
                                $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));

                                if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp'])) {
                                    // Mostrar miniatura
                                    $attachments_html .= '<a href="' . esc_url($file_url) . '" target="_blank"><img src="' . esc_url($file_url) . '" alt="" style="max-width:100px;border-radius:6px;border:1px solid #ccc;"></a>';
                                } else {
                                    // Mostrar icono o enlace
                                    $attachments_html .= '<a href="' . esc_url($file_url) . '" target="_blank" style="display:inline-block;padding:8px 12px;background:#f2f2f2;border-radius:4px;text-decoration:none;">📎 ' . esc_html($file) . '</a>';
                                }
                            }
                            $attachments_html .= '</div>';
                        }

                        // Cuerpo del mensaje en HTML
                        // Cuerpo del mensaje en HTML con formato bonito y responsive

                        $body = '
	<div style="font-family: Arial, Helvetica, sans-serif; color:#333; font-size:20px; line-height:1.6; background:#f8f9fb; padding:20px;">
  	<div style="max-width:600px;margin:0 auto;background:#ffffff;border-radius:10px;overflow:hidden;box-shadow:0 1px 3px rgba(0,0,0,0.08);">
    
    <div style="background:#0073aa;padding:16px 20px;">
      <h2 style="margin:0;font-size:20px;color:white;">📬 Nuevo mensaje recibido</h2>
    </div>

    <div style="padding:20px;font-size:20px">
      
	  <p>Has recibido un nuevo mensaje en <strong>' . $site_label . '</strong>.</p>
	  
      <p style="margin:10px 0;font-size:20px">
        <strong>Remitente:</strong> ' . esc_html($sender_data->display_name) . '<br>
        <strong>Asunto:</strong> ' . esc_html($subject) . '
      </p>

      <div style="background:#f7f7f7;padding:15px;border-radius:6px;margin-top:15px;font-size:20px;">
        ' . wpautop(wp_kses_post($message)) . '
      </div>
';

                        // Adjuntos si existen
                        if (!empty($attachments)) {
                            $files = is_array($attachments) ? $attachments : explode(',', $attachments);
                            $body .= '<hr style="border:none;border-top:1px solid #ddd;margin:25px 0;">';
                            $body .= '<p style="font-weight:bold;margin-bottom:8px;font-size:15px;">Archivos adjuntos:</p>';
                            $body .= '<div style="display:flex;flex-wrap:wrap;gap:10px;">';

                            foreach ($files as $file) {
                                $file = trim($file);
                                $file_url = esc_url($base_url . $file);
                                $protected_url = esc_url(home_url('/archivo-protegido/?file=' . esc_url($base_url . $file)));

                                $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));

                                if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp'])) {
                                    $body .= '<a href="' . $protected_url . '" target="_blank" style="display:inline-block;">
                        <img src="' . $file_url . '" alt="" style="width:100px;height:auto;border-radius:8px;border:1px solid #ccc;">
                      </a>';
                                } else {
                                    $body .= '<a href="' . $protected_url . '" target="_blank" style="display:inline-block;padding:8px 12px;background:#f1f1f1;border-radius:6px;text-decoration:none;color:#0073aa;font-weight:500;">📎 ' . esc_html($file) . '</a>';
                                }
                            }
                            $body .= '</div>';
                        }




                        $body .= '
  <p style="margin-top:30px;text-align:center;">
    <a href="https://' . $domain . '/mensajes/" 
       style="display:inline-block;padding:12px 20px;background:#0073aa;color:white;
       border-radius:6px;text-decoration:none;font-weight:bold;">
       📥 Ver mensaje en tu bandeja
    </a>
  </p>

  <div style="background:#f1f1f1;padding:15px;text-align:center;
       font-size:13px;color:#666;margin-top:25px;border-top:1px solid #ddd;">

    <p style="margin:0 0 6px 0;">
      Este correo fue enviado automáticamente por el sistema de mensajería interna de 
      <strong>' . $domain . '</strong>.
    </p>

    <p style="margin:0 0 6px 0;color:#555;">
      <strong>No respondas desde Gmail u Outlook.</strong><br>
      Las respuestas por correo no llegan al usuario porque no están conectadas al sistema interno.
    </p>

    <p style="margin:0;color:#777;">
      Para contestar, utiliza siempre tu bandeja de mensajes en la web.
    </p>

  </div>
';








                        // Enviar correo en HTML
                        add_filter('wp_mail_content_type', function () {
                            return 'text/html';
                        });
                        wp_mail(
                            $author_data->user_email,
                            '📩 Nuevo mensaje de ' . $sender_data->display_name,
                            $body
                        );
                        remove_filter('wp_mail_content_type', function () {
                            return 'text/html';
                        });
                    }



                    echo '<div style="margin-bottom:15px;padding:10px;background:#d1f7d1;border:1px solid #80c080;border-radius:6px;">
			✅ Mensaje enviado correctamente.</div>';



                    // Redirigir al usuario a la página de "Mensajes enviados"

                    $sent_url = home_url('/mensajes-enviados/?enviado=1');
                    wp_safe_redirect($sent_url);
                    exit;
                } else {
                    foreach ($errors as $e) {
                        echo '<div style="color:red;margin-bottom:5px;">' . esc_html($e) . '</div>';
                    }
                }
            }
            ?>

            <!-- FORMULARIO -->
            <form method="post" enctype="multipart/form-data">
                <?php wp_nonce_field('mi_mensaje_action', 'mi_mensaje_nonce'); ?>

                <label for="buscar_usuario"><strong>Buscar usuario:</strong></label><br>
                <input type="text" id="buscar_usuario" name="buscar_usuario" placeholder="Nombre o alias..." required autocomplete="off" style="width:100%;padding:8px;margin:6px 0;border-radius:6px;">
                <ul id="resultados_busqueda" style="list-style:none;margin:0;padding:0;border:1px solid #ddd;border-radius:6px;display:none;max-height:200px;overflow:auto;"></ul>

                <label for="asunto"><strong>Asunto:</strong></label><br>
                <input type="text" id="asunto" name="asunto" required style="width:100%;padding:8px;margin:6px 0;border-radius:6px;">



                <label for="mensaje"><strong>Mensaje:</strong></label><br>



                <?php

                if (function_exists('wp_enqueue_media')) {
                    wp_enqueue_media();
                }


                wp_enqueue_editor();
                wp_editor(
                    '', // contenido inicial (vacío al redactar un nuevo mensaje)
                    'mensaje', // ID único del editor
                    [
                        'media_buttons' => true, // activar botón de medios
                        //'media_buttons' => false,   // no mostrar botón "Añadir multimedia"
                        'textarea_name' => 'mensaje', // el mismo name que procesas en $_POST
                        'textarea_rows' => 6,
                        'teeny'         => true,     // versión simplificada del editor
                        'quicktags'     => true,     // habilita etiquetas HTML básicas (p, strong…)
                    ]
                );
                ?>




                <label for="attachments"><strong>Adjuntar archivos (máx:3, tamaño max.:2 Mb.):</strong></label><br>
                <small style="color: #28a745; font-size: 0.9em; display: block; margin-bottom: 8px;">
                    <b>Tipos</b> de archivos admitidos: <br>
                    jpg, jpeg, png, gif (imágenes)<br>
                    pdf (documentos)<br>
                </small>

                <input type="file" name="attachments[]" id="file-input" multiple />
                <div id="preview-container"></div>

                <input type="submit" value="Enviar mensaje" style="margin-top:10px;background:#0073aa;color:#fff;padding:10px 16px;border:none;border-radius:6px;cursor:pointer;">
            </form>
        </div>



        <?php
        // ------------------------------
        //     LÍMITES PHP
        // ------------------------------
        $upload_max = ini_get('upload_max_filesize');
        $post_max   = ini_get('post_max_size');
        $max_files_php = ini_get('max_file_uploads');

        function mm_bytes($val)
        {
            $val = trim($val);
            $last = strtolower($val[strlen($val) - 1]);
            $val = (int) $val;
            switch ($last) {
                case 'g':
                    $val *= 1024;
                case 'm':
                    $val *= 1024;
                case 'k':
                    $val *= 1024;
            }
            return $val;
        }

        $upload_max_bytes = mm_bytes($upload_max);
        $post_max_bytes   = mm_bytes($post_max);
        $php_effective_limit = min($upload_max_bytes, $post_max_bytes);

        if ($php_effective_limit < $max_total_plugin): ?>

            <div class="mm-warning">
                <strong>⚠️ Advertencia:</strong> El servidor tiene un límite de
                <strong><?php echo size_format($php_effective_limit); ?></strong>,
                pero el plugin está configurado para permitir
                <strong><?php echo size_format($max_total_plugin); ?></strong>.
                <br><br>
                Debes aumentar <code>upload_max_filesize</code> y <code>post_max_size</code> en tu hosting
                para asegurar una subida correcta de archivos.
            </div>

        <?php else: ?>

            <div class="mm-ok">
                <strong>✔ Todo está correcto.</strong>
                Tu servidor soporta los límites configurados por el plugin.
            </div>

        <?php endif; ?>
    </div>








    <?php get_footer(); ?>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const input = document.getElementById('buscar_usuario');
            const resultados = document.getElementById('resultados_busqueda');

            input.addEventListener('input', function() {
                const termino = this.value.trim();
                if (termino.length < 2) {
                    resultados.style.display = 'none';
                    resultados.innerHTML = '';
                    return;
                }

                fetch('<?php echo admin_url('admin-ajax.php'); ?>?action=buscar_usuarios_bp&term=' + encodeURIComponent(termino))
                    .then(response => response.json())
                    .then(data => {
                        resultados.innerHTML = '';
                        if (data.length) {
                            resultados.style.display = 'block';
                            data.forEach(usuario => {
                                const li = document.createElement('li');
                                li.style.padding = '8px';
                                li.style.cursor = 'pointer';
                                li.style.display = 'flex';
                                li.style.alignItems = 'center';
                                li.style.gap = '10px';
                                li.innerHTML = `<img src="${usuario.avatar}" width="32" height="32" style="border-radius:50%;"><span><strong>${usuario.display_name}</strong> <small>(${usuario.user_login})</small></span>`;
                                li.addEventListener('click', function() {
                                    input.value = usuario.user_login;
                                    resultados.innerHTML = '';
                                    resultados.style.display = 'none';
                                });
                                resultados.appendChild(li);
                            });
                        } else {
                            resultados.innerHTML = '<li style="padding:8px;color:#999;">Sin resultados</li>';
                            resultados.style.display = 'block';
                        }
                    });
            });
        });
    </script>


    <?php
    $limits = mi_mensaje_get_upload_limits();
    ?>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const inputFiles = document.querySelector('input[name="attachments[]"]');
            // Valores enviados desde PHP
            const maxFiles = <?php echo (int) $limits['max_files']; ?>;
            const maxTotalSizeMB = <?php echo (int) $limits['max_total_mb']; ?>;
            const allowedExtensions = <?php echo json_encode($limits['allowed_ext']); ?>;
            const maxTotalSizeBytes = maxTotalSizeMB * 1024 * 1024;


            inputFiles?.addEventListener('change', function() {
                if (this.files.length > maxFiles) {
                    alert(`Solo puedes subir hasta ${maxFiles} archivos.`);
                    this.value = '';
                    return;
                }

                let totalSize = 0;
                for (let i = 0; i < this.files.length; i++) {

                    const file = this.files[i];

                    // 🔹 Validar extensión
                    const ext = file.name.split('.').pop().toLowerCase();
                    if (!allowedExtensions.includes(ext)) {
                        alert(`El archivo "${file.name}" no está permitido.`);
                        this.value = '';
                        return;
                    }

                    totalSize += this.files[i].size;
                    if (this.files[i].size > maxTotalSizeBytes) {
                        alert(`El archivo "${this.files[i].name}" es demasiado grande.`);
                        this.value = '';
                        return;
                    }
                }

                if (totalSize > maxTotalSizeBytes) {
                    alert(`El tamaño total de los archivos no puede superar ${maxTotalSizeMB} MB.`);
                    this.value = '';
                }
            });
        });
    </script>



    <script>
        document.getElementById('file-input').addEventListener('change', function(event) {
            const files = event.target.files;
            const previewContainer = document.getElementById('preview-container');
            previewContainer.innerHTML = ''; // Limpiar contenedor previo

            for (let i = 0; i < files.length; i++) {
                const file = files[i];
                const reader = new FileReader();

                reader.onload = function(e) {
                    const div = document.createElement('div');
                    div.className = 'file-preview';

                    if (file.type.startsWith('image/')) {
                        const img = document.createElement('img');
                        img.src = e.target.result;
                        img.alt = file.name;
                        div.appendChild(img);



                    } else {
                        const p = document.createElement('p');
                        p.textContent = file.name; // Para otros tipos de archivo muestra solo el nombre
                        div.appendChild(p);
                    }

                    previewContainer.appendChild(div);
                };

                reader.readAsDataURL(file); // Leer archivo como URL
            }
        });
    </script>